/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.logger.Logger;
import com.raplix.util.sql.ColumnDefinition;
import com.raplix.util.sql.Database;
import com.raplix.util.sql.SQLTableMap;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SQLObject {
    protected static Database sDefaultDatabase;
    public static final int INTEGER = 1;
    public static final int STRING = 2;
    public static final int DATE = 3;
    public static final int BOOLEAN = 4;
    public static final int BLOB = 5;
    public static final int LONG = 6;
    public static int gDebugLevel;
    public static final int DEBUGVERBOSE = 10;
    public static final int DEBUGMODERATE = 2;
    protected boolean mAutoGenerateKeys = false;

    public static void registerDefaultDatabase(Database inDB) {
        sDefaultDatabase = inDB;
    }

    public static Database getDefaultDatabase() {
        return sDefaultDatabase;
    }

    public void reconstitute(ResultSet inRS) throws SQLException {
        SQLObject.reconstituteObject(this, SQLTableMap.findObjectMap(this), inRS);
    }

    public String buildMySQLCreate() throws SQLException {
        return SQLObject.constructMySQLCreateTableStatement(SQLTableMap.findObjectMap(this));
    }

    public String generateHTTPForm() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("<FORM ACTION=... METHOD=...>");
            SQLTableMap map = SQLTableMap.findObjectMap(this);
            Enumeration elems = map.getMappings().elements();
            while (elems.hasMoreElements()) {
                ColumnDefinition cd = (ColumnDefinition)elems.nextElement();
                sb.append(cd.getFieldName().substring(1));
                switch (cd.getColumnType()) {
                    case 1: {
                        sb.append("<INPUT TYPE=TEXT NAME=" + cd.getFieldName() + ">");
                        break;
                    }
                    case 2: {
                        sb.append("<INPUT TYPE=TEXT NAME=" + cd.getFieldName() + ">");
                        break;
                    }
                    case 3: {
                        sb.append("<INPUT TYPE=TEXT NAME=" + cd.getFieldName() + ">");
                        break;
                    }
                    case 4: {
                        sb.append("<INPUT TYPE=CHECKED NAME=" + cd.getFieldName() + ">");
                    }
                }
                if (map.getKeys().contains(cd.getFieldName())) {
                    sb.append(" - key; optional for new records");
                }
                sb.append("<BR>");
            }
        }
        catch (Exception e) {
            ColumnDefinition.logError(1, "SQLObject", e);
        }
        return sb.toString();
    }

    protected static void reconstituteObject(Object ioObj, SQLTableMap inMap, ResultSet inRS) throws SQLException {
        if (!(ioObj instanceof SQLObject)) {
            throw new SQLException("Object passed to reconstituteObject must be a SQLObject.");
        }
        ((SQLObject)ioObj).mAutoGenerateKeys = false;
        Enumeration keys = inMap.getMappings().elements();
        while (keys.hasMoreElements()) {
            try {
                ColumnDefinition cd = (ColumnDefinition)keys.nextElement();
                Field theField = inMap.getMappedClass().getField(cd.getFieldName());
                cd.setFieldFromRow(theField, ioObj, inRS);
            }
            catch (Exception e) {
                e.printStackTrace();
                ColumnDefinition.logError(1, "SQLObject", e);
            }
        }
    }

    protected static Hashtable constructValuesTable(SQLObject ioObj, SQLTableMap inMap) {
        Enumeration keys = inMap.getMappings().elements();
        Hashtable outTable = new Hashtable();
        while (keys.hasMoreElements()) {
            try {
                ColumnDefinition cd = (ColumnDefinition)keys.nextElement();
                Field theField = inMap.getMappedClass().getField(cd.getFieldName());
                cd.setRowFromField(theField, ioObj, outTable);
            }
            catch (Exception e) {
                ColumnDefinition.logError(1, "SQLObject", e);
            }
        }
        return outTable;
    }

    protected static Hashtable buildQuery(String inField, String inValue) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put(inField, inValue);
        return t;
    }

    protected static Object[] selectObjects(Hashtable inQueryParams, SQLTableMap inMap) {
        return SQLObject.selectObjects(inQueryParams, inMap, null);
    }

    protected static Object[] selectObjects(Hashtable inQueryParams, SQLTableMap inMap, Vector inOrderParams) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = sDefaultDatabase.getConnectionWithRetry();
            stmt = conn.createStatement();
            Vector results = new Vector();
            String query = SQLObject.constructSelectStatement(inQueryParams, inMap, inOrderParams);
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object o = inMap.getMappedClass().newInstance();
                SQLObject.reconstituteObject(o, inMap, rs);
                results.addElement(o);
            }
            stmt.close();
            sDefaultDatabase.returnConnection(conn);
            Object[] oArray = (Object[])Array.newInstance(inMap.getMappedClass(), results.size());
            results.copyInto(oArray);
            return oArray;
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            sDefaultDatabase.returnConnection(conn);
            e.printStackTrace();
            ColumnDefinition.logError(1, "SQLObject.selectObjects ", e);
            return null;
        }
    }

    protected static Object selectObject(String inWhereAndOrderBy, SQLTableMap inMap) {
        Object[] theObjects = SQLObject.selectObjects(inWhereAndOrderBy, inMap);
        return theObjects[0];
    }

    protected static Object[] selectObjects(String inWhereAndOrderBy, SQLTableMap inMap) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = sDefaultDatabase.getConnectionWithRetry();
            stmt = conn.createStatement();
            Vector results = new Vector();
            String query = "SELECT * FROM " + inMap.getTableName();
            if (!inWhereAndOrderBy.equals("")) {
                query = query + " WHERE " + inWhereAndOrderBy;
            }
            SQLObject.logDebug("SQLObject.selectObjects " + query, new SQLObject());
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object o = inMap.getMappedClass().newInstance();
                SQLObject.reconstituteObject(o, inMap, rs);
                results.addElement(o);
            }
            stmt.close();
            sDefaultDatabase.returnConnection(conn);
            Object[] oArray = (Object[])Array.newInstance(inMap.getMappedClass(), results.size());
            results.copyInto(oArray);
            return oArray;
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            sDefaultDatabase.returnConnection(conn);
            e.printStackTrace();
            ColumnDefinition.logError(1, "SQLObject.selectObjects ", e);
            return null;
        }
    }

    public void insert() throws SQLException {
        SQLTableMap Map2 = SQLTableMap.findObjectMap(this);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = sDefaultDatabase.getConnectionWithRetry();
            stmt = conn.createStatement();
            String query = SQLObject.constructInsertStatement(this, Map2);
            SQLObject.logDebug("SQLObject.insertObject " + query, this);
            stmt.executeUpdate(query);
            SQLObject.logDebug("SQLObject.insertObject " + query + " succeeded", this);
            stmt.close();
            stmt = null;
            sDefaultDatabase.returnConnection(conn);
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                ColumnDefinition.logError(1, "SQLObject", sqle);
            }
            ColumnDefinition.logError(1, "SQLObject", e);
            sDefaultDatabase.returnConnection(conn);
            throw e;
        }
        catch (Exception generalE) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                ColumnDefinition.logError(1, "SQLObject", sqle);
            }
            ColumnDefinition.logError(1, "SQLObject", generalE);
            sDefaultDatabase.returnConnection(conn);
        }
    }

    public static void logDebug(String inMessage, Object inObj) {
        if (gDebugLevel == 1 && Logger.isDebugEnabled(inObj) && gDebugLevel == 1) {
            Logger.debug(inMessage, inObj);
        }
    }

    public void update() throws SQLException {
        SQLTableMap Map2 = SQLTableMap.findObjectMap(this);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = sDefaultDatabase.getConnection();
            stmt = conn.createStatement();
            String query = SQLObject.constructUpdateStatement(this, Map2);
            SQLObject.logDebug("SQLObject.updateObject " + query, this);
            stmt.executeUpdate(query);
            stmt.close();
            stmt = null;
            sDefaultDatabase.returnConnection(conn);
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            sDefaultDatabase.returnConnection(conn);
        }
    }

    public void delete() throws SQLException {
        SQLTableMap Map2 = SQLTableMap.findObjectMap(this);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = sDefaultDatabase.getConnection();
            stmt = conn.createStatement();
            String query = SQLObject.constructDeleteStatement(this, Map2);
            SQLObject.logDebug("SQLObject.deleteObject " + query, this);
            stmt.executeUpdate(query);
            stmt.close();
            stmt = null;
            sDefaultDatabase.returnConnection(conn);
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            sDefaultDatabase.returnConnection(conn);
        }
    }

    protected static String constructSelectStatement(Hashtable inQueryParams, SQLTableMap inMap, Vector inOrderParams) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM " + inMap.getTableName());
        if (inQueryParams != null) {
            Enumeration keys = inMap.getMappings().elements();
            boolean any = false;
            while (keys.hasMoreElements()) {
                ColumnDefinition cd = (ColumnDefinition)keys.nextElement();
                String inQueryValue = (String)inQueryParams.get(cd.getFieldName());
                if (inQueryValue == null) continue;
                if (any) {
                    sb.append(" AND ");
                } else {
                    sb.append(" WHERE ");
                }
                any = true;
                sb.append(cd.getColumnName());
                sb.append("=");
                sb.append(inQueryValue);
            }
        }
        if (inOrderParams != null) {
            Enumeration order = inOrderParams.elements();
            boolean first = true;
            while (order.hasMoreElements()) {
                String orderTerm = (String)order.nextElement();
                ColumnDefinition cd = inMap.getColumnForField(orderTerm);
                if (cd == null) continue;
                if (first) {
                    sb.append(" ORDER BY ");
                } else {
                    sb.append(", ");
                }
                sb.append(cd.getColumnName());
            }
        }
        return sb.toString();
    }

    protected static String constructInsertStatement(SQLObject inObj, SQLTableMap inMap) {
        ColumnDefinition cd;
        StringBuffer sb = new StringBuffer();
        Hashtable values = SQLObject.constructValuesTable(inObj, inMap);
        sb.append("INSERT INTO " + inMap.getTableName() + " (");
        Enumeration elems = inMap.getMappings().elements();
        boolean first = true;
        while (elems.hasMoreElements()) {
            cd = (ColumnDefinition)elems.nextElement();
            if (inObj.mAutoGenerateKeys && inMap.getKeys().contains(cd.getColumnName())) {
                if (sDefaultDatabase.getDatabaseType() != 1) continue;
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(cd.getColumnName());
                continue;
            }
            if (values.get(cd.getColumnName()) == null && !(!inMap.isDefaultInsert(cd.getColumnName()) & !inMap.isReadOnly(cd.getColumnName()))) continue;
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(cd.getColumnName());
        }
        sb.append(") values (");
        first = true;
        elems = inMap.getMappings().elements();
        while (elems.hasMoreElements()) {
            cd = (ColumnDefinition)elems.nextElement();
            if (inObj.mAutoGenerateKeys && inMap.getKeys().contains(cd.getColumnName())) {
                if (sDefaultDatabase.getDatabaseType() != 1) continue;
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(cd.getColumnName() + ".nextVal");
                continue;
            }
            if (values.get(cd.getColumnName()) == null && !(!inMap.isDefaultInsert(cd.getColumnName()) & !inMap.isReadOnly(cd.getColumnName()))) continue;
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(values.get(cd.getColumnName()));
        }
        sb.append(")");
        return sb.toString();
    }

    protected static PreparedStatement constructPreparedInsertStatement(Connection inConn, SQLObject inObj, SQLTableMap inMap) throws SQLException {
        ColumnDefinition cd;
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + inMap.getTableName() + " (");
        Enumeration elems = inMap.getMappings().elements();
        boolean first = true;
        while (elems.hasMoreElements()) {
            cd = (ColumnDefinition)elems.nextElement();
            if (inObj.mAutoGenerateKeys && inMap.getKeys().contains(cd.getColumnName())) continue;
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(cd.getColumnName());
        }
        sb.append(") values (");
        first = true;
        elems = inMap.getMappings().elements();
        while (elems.hasMoreElements()) {
            cd = (ColumnDefinition)elems.nextElement();
            if (inObj.mAutoGenerateKeys && inMap.getKeys().contains(cd.getColumnName())) continue;
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("?");
        }
        sb.append(")");
        PreparedStatement stmt = inConn.prepareStatement(sb.toString());
        int index = 1;
        try {
            elems = inMap.getMappings().elements();
            while (elems.hasMoreElements()) {
                ColumnDefinition cd2 = (ColumnDefinition)elems.nextElement();
                if (inObj.mAutoGenerateKeys && inMap.getKeys().contains(cd2.getColumnName())) continue;
                Field theField = inMap.getMappedClass().getField(cd2.getFieldName());
                cd2.setPreparedStatementValue(theField, inObj, index, stmt);
                ++index;
            }
        }
        catch (NoSuchFieldException nsf) {
            throw new SQLException("Unknown field encountered during preparation of insert statement: " + nsf.toString());
        }
        return stmt;
    }

    protected static String constructUpdateStatement(SQLObject inObj, SQLTableMap inMap) {
        StringBuffer sb = new StringBuffer();
        Hashtable values = SQLObject.constructValuesTable(inObj, inMap);
        sb.append("UPDATE " + inMap.getTableName() + " SET ");
        Enumeration elems = inMap.getMappings().elements();
        boolean first = true;
        while (elems.hasMoreElements()) {
            ColumnDefinition cd = (ColumnDefinition)elems.nextElement();
            if (inMap.isReadOnly(cd.getColumnName())) continue;
            if (!first) {
                sb.append(",");
            }
            sb.append(cd.getColumnName());
            sb.append("=");
            sb.append(values.get(cd.getColumnName()));
            first = false;
        }
        Enumeration keys = inMap.getKeys().elements();
        sb.append(" WHERE ");
        boolean any = false;
        while (keys.hasMoreElements()) {
            String theKey = (String)keys.nextElement();
            ColumnDefinition cd = (ColumnDefinition)inMap.getMappings().get(theKey);
            String inQueryValue = (String)values.get(cd.getColumnName());
            if (inQueryValue == null) continue;
            if (any) {
                sb.append(" AND ");
            }
            any = true;
            sb.append(cd.getColumnName());
            sb.append("=");
            sb.append(inQueryValue);
        }
        return sb.toString();
    }

    protected static String constructDeleteStatement(SQLObject inObj, SQLTableMap inMap) {
        StringBuffer sb = new StringBuffer();
        Hashtable values = SQLObject.constructValuesTable(inObj, inMap);
        sb.append("DELETE FROM " + inMap.getTableName());
        Enumeration keys = inMap.getKeys().elements();
        sb.append(" WHERE ");
        boolean any = false;
        while (keys.hasMoreElements()) {
            String theKey = (String)keys.nextElement();
            ColumnDefinition cd = (ColumnDefinition)inMap.getMappings().get(theKey);
            String inQueryValue = (String)values.get(cd.getColumnName());
            if (inQueryValue == null) continue;
            if (any) {
                sb.append(" AND ");
            }
            any = true;
            sb.append(cd.getColumnName());
            sb.append("=");
            sb.append(inQueryValue);
        }
        return sb.toString();
    }

    protected static String constructMySQLCreateTableStatement(SQLTableMap inMap) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE " + inMap.getTableName() + " (");
        Enumeration<Object> keys = inMap.getMappings().elements();
        while (keys.hasMoreElements()) {
            ColumnDefinition cd = (ColumnDefinition)keys.nextElement();
            sb.append(cd.getColumnName());
            switch (cd.getColumnType()) {
                case 4: {
                    sb.append(" INT");
                    break;
                }
                case 3: {
                    sb.append(" TIMESTAMP");
                    break;
                }
                case 1: {
                    sb.append(" INT");
                    break;
                }
                case 2: {
                    sb.append(" TEXT");
                }
            }
            if (!keys.hasMoreElements()) continue;
            sb.append(",");
        }
        keys = inMap.getKeys().elements();
        while (keys.hasMoreElements()) {
            sb.append(",");
            String key = (String)keys.nextElement();
            sb.append(" primary key (" + key + ")");
        }
        sb.append(")");
        return sb.toString();
    }

    public static int getSequenceNextVal(String inSeqName) {
        int outVal = 0;
        Connection conn = null;
        Statement stmt = null;
        String query = null;
        try {
            conn = sDefaultDatabase.getConnectionWithRetry();
            stmt = conn.createStatement();
            query = "Select nextval('" + inSeqName + "')";
            ResultSet rs = stmt.executeQuery(query);
            rs.next();
            outVal = rs.getInt(1);
            stmt.close();
            sDefaultDatabase.returnConnection(conn);
            return outVal;
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            sDefaultDatabase.returnConnection(conn);
            e.printStackTrace();
            ColumnDefinition.logError(1, "SQLObject.getSequenceNextVal ", e);
            return 0;
        }
    }

    public static long getAdHocLongColumnValue(String inQuery) {
        Connection conn = null;
        Statement stmt = null;
        String query = null;
        try {
            conn = sDefaultDatabase.getConnectionWithRetry();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            rs.next();
            long outVal = rs.getLong(1);
            stmt.close();
            sDefaultDatabase.returnConnection(conn);
            return outVal;
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            sDefaultDatabase.returnConnection(conn);
            e.printStackTrace();
            ColumnDefinition.logError(1, "SQLObject.getAdHocLongColumnValue ", e);
            return 0L;
        }
    }

    public SQLTableMap getMap() {
        SQLTableMap tMap = null;
        try {
            tMap = SQLTableMap.findObjectMap(this);
            return tMap;
        }
        catch (SQLException sqle) {
            return tMap;
        }
    }

    static {
        gDebugLevel = 1;
    }
}

