/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.Database;
import com.raplix.util.sql.SQLQuery;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class SQLInsert
extends SQLQuery {
    protected String mTable;
    protected Vector mColumns = new Vector();
    protected Vector mValues = new Vector();

    public SQLInsert(Database db, String table) throws SQLException {
        super(db);
        this.mTable = table;
    }

    public void addColumn(String column, String value) {
        this.mColumns.addElement(column);
        this.mValues.addElement(value);
    }

    public void addColumn(String column, int value) {
        this.mColumns.addElement(column);
        this.mValues.addElement(new Integer(value));
    }

    public void addColumn(String column, Object value) {
        if (value instanceof Integer) {
            this.addColumn(column, (Integer)value);
        } else {
            this.addColumn(column, value.toString());
        }
    }

    public ResultSet execute() throws SQLException {
        String q = this.generateQuery();
        this.mStatement.executeUpdate(q);
        return null;
    }

    public String generateQuery() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + this.mTable + " (");
        for (i = 0; i < this.mColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.mColumns.elementAt(i));
        }
        sb.append(") values (");
        for (i = 0; i < this.mValues.size(); ++i) {
            Object o;
            if (i > 0) {
                sb.append(", ");
            }
            if ((o = this.mValues.elementAt(i)) instanceof Integer) {
                sb.append(o.toString());
                continue;
            }
            sb.append("'" + o.toString() + "'");
        }
        sb.append(")");
        return sb.toString();
    }
}

