/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.ColumnDefinition;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LongColumnDefinition
extends ColumnDefinition {
    public LongColumnDefinition(String inColumnName, String inFieldName) {
        super(inColumnName, inFieldName);
    }

    public int getColumnType() {
        return 6;
    }

    public void setFieldFromRow(Field inField, Object inObject, ResultSet inResultSet) {
        try {
            if (inField.getType().isArray()) {
                String theArrayStr = inResultSet.getString(this.getColumnName());
                StringTokenizer strTok = new StringTokenizer(theArrayStr, "{}\",");
                int theArraySize = strTok.countTokens();
                long[] theValue = new long[theArraySize];
                for (int i = 0; i < theArraySize; ++i) {
                    String theToken = strTok.nextToken();
                    theValue[i] = Long.parseLong(theToken);
                }
                inField.set(inObject, theValue);
            } else {
                long theValue = inResultSet.getLong(this.getColumnName());
                inField.setLong(inObject, theValue);
            }
        }
        catch (Exception e) {
            LongColumnDefinition.logError(2, "During setFieldFromRow for " + this.getColumnName(), e);
        }
    }

    public void setRowFromField(Field inField, Object inObject, Hashtable inValues) {
        try {
            if (inField.getType().isArray()) {
                Object theArray = inField.get(inObject);
                String theArrayStr = null;
                if (theArray != null) {
                    int arrLen = Array.getLength(theArray);
                    if (arrLen > 0) {
                        theArrayStr = "'{";
                    }
                    for (int i = 0; i < arrLen; ++i) {
                        long theVal = Array.getLong(theArray, i);
                        theArrayStr = i > 0 ? theArrayStr + "," + theVal : theArrayStr + theVal;
                    }
                    if (arrLen > 0) {
                        theArrayStr = theArrayStr + "}'";
                    }
                }
                inValues.put(this.getColumnName(), theArrayStr);
            } else {
                long theValue = inField.getLong(inObject);
                inValues.put(this.getColumnName(), "" + theValue);
            }
        }
        catch (Exception e) {
            LongColumnDefinition.logError(2, "During setRowFromField for " + this.getColumnName(), e);
        }
    }

    public void setPreparedStatementValue(Field inField, Object inObject, int inIndex, PreparedStatement inStatement) {
        try {
            if (inField.getType().isArray()) {
                throw new Exception("Array of longs in a prepared statement is not supported yet.");
            }
            long theValue = inField.getLong(inObject);
            inStatement.setLong(inIndex, theValue);
        }
        catch (Exception e) {
            LongColumnDefinition.logError(2, "During setPreparedStatementValue for " + this.getColumnName(), e);
        }
    }
}

