/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.ColumnDefinition;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;

public class IntegerColumnDefinition
extends ColumnDefinition {
    public IntegerColumnDefinition(String inColumnName, String inFieldName) {
        super(inColumnName, inFieldName);
    }

    public int getColumnType() {
        return 1;
    }

    public void setFieldFromRow(Field inField, Object inObject, ResultSet inResultSet) {
        try {
            int theValue = inResultSet.getInt(this.getColumnName());
            inField.setInt(inObject, theValue);
        }
        catch (Exception e) {
            IntegerColumnDefinition.logError(2, "During setFieldFromRow for " + this.getColumnName(), e);
        }
    }

    public void setRowFromField(Field inField, Object inObject, Hashtable inValues) {
        try {
            int theValue = inField.getInt(inObject);
            inValues.put(this.getColumnName(), "" + theValue);
        }
        catch (Exception e) {
            IntegerColumnDefinition.logError(2, "During setRowFromField for " + this.getColumnName(), e);
        }
    }

    public void setPreparedStatementValue(Field inField, Object inObject, int inIndex, PreparedStatement inStatement) {
        try {
            int theValue = inField.getInt(inObject);
            inStatement.setInt(inIndex, theValue);
        }
        catch (Exception e) {
            IntegerColumnDefinition.logError(2, "During setPreparedStatementValue for " + this.getColumnName(), e);
        }
    }
}

