/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

public class DriverUtilities {
    public static final int ORACLE = 1;
    public static final int SYBASE = 2;
    public static final int UNKNOWN = -1;

    public static String makeURL(String host, String dbName, int vendor) {
        if (vendor == 1) {
            return "jdbc:oracle:thin:@" + host + ":1521:" + dbName;
        }
        if (vendor == 2) {
            return "jdbc:sybase:Tds:" + host + ":1521" + "?SERVICENAME=" + dbName;
        }
        return null;
    }

    public static String getDriver(int vendor) {
        if (vendor == 1) {
            return "oracle.jdbc.driver.OracleDriver";
        }
        if (vendor == 2) {
            return "com.sybase.jdbc.SybDriver";
        }
        return null;
    }

    public static int getVendor(String vendorName) {
        if (vendorName.equalsIgnoreCase("oracle")) {
            return 1;
        }
        if (vendorName.equalsIgnoreCase("sybase")) {
            return 2;
        }
        return -1;
    }
}

