/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.ColumnDefinition;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class DateColumnDefinition
extends ColumnDefinition {
    static SimpleDateFormat sDateFormat = new SimpleDateFormat("hh:mm a MMM/dd/yyyy");
    static SimpleDateFormat sMySQLDateFormat = new SimpleDateFormat("yyyy-MM-dd h:mm:ss");

    public static String formatDate(Date inDate) {
        if (inDate == null) {
            return "";
        }
        return sDateFormat.format(inDate);
    }

    public DateColumnDefinition(String inColumnName, String inFieldName) {
        super(inColumnName, inFieldName);
    }

    public int getColumnType() {
        return 3;
    }

    public void setFieldFromRow(Field inField, Object inObject, ResultSet inResultSet) {
        try {
            Timestamp theValue = inResultSet.getTimestamp(this.getColumnName());
            if (theValue == null || theValue.getTime() == 0L) {
                inField.set(inObject, null);
            } else {
                java.sql.Date theDate = new java.sql.Date(theValue.getTime());
                if (theDate != null) {
                    // empty if block
                }
                inField.set(inObject, theDate);
            }
        }
        catch (Exception e) {
            DateColumnDefinition.logError(2, "During setFieldFromRow for " + this.getColumnName(), e);
        }
    }

    public void setRowFromField(Field inField, Object inObject, Hashtable inValues) {
        try {
            Object theValue = inField.get(inObject);
            if (theValue == null) {
                inValues.put(this.getColumnName(), "null");
            } else {
                inValues.put(this.getColumnName(), "to_date('" + sDateFormat.format((Date)theValue) + "', '" + "HH:MI AM MON/DD/YYYY" + "')");
            }
        }
        catch (Exception e) {
            DateColumnDefinition.logError(2, "During setRowFromField for " + this.getColumnName(), e);
        }
    }

    public void setPreparedStatementValue(Field inField, Object inObject, int inIndex, PreparedStatement inStatement) {
        try {
            Object theValue = inField.get(inObject);
            if (!(theValue instanceof java.sql.Date)) {
                throw new Exception("DateColumn Unable to set date; value was of type " + theValue.getClass());
            }
            inStatement.setDate(inIndex, (java.sql.Date)theValue);
        }
        catch (Exception e) {
            DateColumnDefinition.logError(2, "During setPreparedStatementValue for " + this.getColumnName(), e);
        }
    }
}

