/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.logger.Logger;
import com.raplix.util.sql.ColumnDefinition;
import com.raplix.util.threads.SafeThread;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Stack;

public class Database {
    protected FileWriter sConnectionLog = null;
    protected DateFormat sDateFormat = DateFormat.getDateTimeInstance(3, 3);
    public boolean mInProgressCleanup = false;
    public static final int ORACLE = 1;
    public static final int MYSQL = 2;
    public static final int POSTGRESQL = 3;
    public int mDatabaseType = 0;
    private int mNumConnections;
    private int mDesiredConnections;
    private String mDatabaseURL;
    private String mUser;
    private String mPassword;
    private Stack mFreeConnectionList;
    private Stack mUsedConnectionList;
    private static boolean OUTPUT_STATUS = false;

    public Database(String url, String user, String password, int numConnections, boolean weedOutOldDBConnections) {
        if (OUTPUT_STATUS) {
            this.log("Creating pool to: " + url);
        }
        this.mFreeConnectionList = new Stack();
        this.mUsedConnectionList = new Stack();
        this.mNumConnections = 0;
        this.mDesiredConnections = numConnections;
        this.mDatabaseURL = url;
        this.mUser = user;
        this.mPassword = password;
        this.createUpdatePoolThread();
        if (weedOutOldDBConnections) {
            this.createWeedOutThread();
        }
    }

    protected void createUpdatePoolThread() {
        final Database pool = this;
        SafeThread updatePoolSizeThread = new SafeThread(){

            public void run() {
                try {
                    while (!pool.mInProgressCleanup) {
                        pool.updatePoolSize();
                        1.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        updatePoolSizeThread.start();
    }

    protected void createWeedOutThread() {
        final Database pool = this;
        SafeThread weedOutOldDBConnectionsThread = new SafeThread(){

            public void run() {
                try {
                    while (!pool.mInProgressCleanup) {
                        2.sleep(600000L);
                        Connection c = null;
                        while (c == null) {
                            c = Database.this.getConnection();
                        }
                        Database.this.returnConnection(c, true);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        weedOutOldDBConnectionsThread.start();
    }

    public int getDatabaseType() {
        return this.mDatabaseType;
    }

    public void setDatabaseType(int inNewType) {
        this.mDatabaseType = inNewType;
    }

    public synchronized int getNumConnections() {
        return this.mNumConnections;
    }

    public synchronized int getNumFreeConnections() {
        return this.mFreeConnectionList.size();
    }

    public synchronized int getNumConnectionsInUse() {
        return this.mUsedConnectionList.size();
    }

    public synchronized int getDesiredNumConnections() {
        return this.mDesiredConnections;
    }

    public synchronized void setPoolSize(int num) {
        this.mDesiredConnections = num;
    }

    public synchronized void updatePoolSize() {
        if (this.mDesiredConnections == this.mNumConnections) {
            return;
        }
        if (this.mDesiredConnections < this.mNumConnections) {
            Connection c = this.getConnection();
            if (c == null) {
                return;
            }
            this.returnConnection(c, true);
        } else {
            Connection c = this.createConnection();
            if (c != null) {
                this.mFreeConnectionList.push(c);
                ++this.mNumConnections;
            } else {
                System.err.println("Can't connect to database.");
            }
        }
    }

    private synchronized Connection createConnection() {
        if (OUTPUT_STATUS) {
            this.log("Creating new connection.");
        }
        try {
            Connection conn = DriverManager.getConnection(this.mDatabaseURL, this.mUser, this.mPassword);
            if (conn == null) {
                return null;
            }
            Statement stmt = conn.createStatement();
            stmt.close();
            if (OUTPUT_STATUS) {
                this.log("Successfully created connection.");
            }
            return conn;
        }
        catch (SQLException e1) {
            if (OUTPUT_STATUS) {
                this.log("Error while creating connection: " + e1.toString());
            }
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Database", this);
            }
            return null;
        }
    }

    public synchronized Connection getConnection() {
        boolean needToRetry;
        if (OUTPUT_STATUS) {
            this.log("Trying to get a connection.");
        }
        Connection conn = null;
        do {
            needToRetry = false;
            if (this.mFreeConnectionList.size() <= 0) continue;
            conn = (Connection)this.mFreeConnectionList.pop();
            this.mUsedConnectionList.push(conn);
            try {
                if (conn.isClosed()) {
                    throw new SQLException();
                }
                Statement stmt = conn.createStatement();
                stmt.close();
            }
            catch (SQLException e) {
                this.returnConnection(conn, true);
                conn = null;
                needToRetry = true;
            }
        } while (needToRetry);
        if (OUTPUT_STATUS) {
            if (conn == null) {
                this.log("Unable to get a connection.");
            } else {
                this.log("Got a connection.");
            }
        }
        return conn;
    }

    public Connection getConnectionWithRetry() throws SQLException {
        Connection conn;
        int attempts = 0;
        while ((conn = this.getConnection()) == null) {
            if (++attempts == 10) {
                throw new SQLException("getConnectionWithRetry(): Couldn't get connection after 10 tries");
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                ColumnDefinition.logError(1, "getConnectionWithRetry", ie);
                throw new SQLException("(Interrupted) Couldn't get connection after 10 tries.");
            }
        }
        return conn;
    }

    public void returnConnection(Connection conn) {
        this.returnConnection(conn, false);
    }

    public synchronized void returnConnection(Connection conn, boolean killit) {
        if (OUTPUT_STATUS) {
            this.log("Returning a connection, killit\t= " + killit + ", ...");
        }
        if (conn == null) {
            if (OUTPUT_STATUS) {
                this.log("null\tconnection.");
            }
            return;
        }
        this.mUsedConnectionList.removeElement(conn);
        boolean dead = false;
        SQLWarning warning = null;
        try {
            if (killit) {
                conn.close();
                throw new SQLException("Closed connection");
            }
            warning = conn.getWarnings();
            if (warning != null) {
                throw new SQLException("SQL\twarning: " + warning);
            }
            if (conn.isClosed()) {
                throw new SQLException("The\tdatabase connection\tis already closed.");
            }
            if (this.mInProgressCleanup) {
                conn.close();
                throw new SQLException("The\tdatabase connections are being cleaned up and removed.");
            }
        }
        catch (SQLException e) {
            dead = true;
            this.mFreeConnectionList.removeElement(conn);
            this.log("Removed DB connection: " + e);
        }
        if (dead) {
            if (OUTPUT_STATUS) {
                this.log("Connection was killed.");
            }
            --this.mNumConnections;
        } else {
            if (OUTPUT_STATUS) {
                this.log("Connection was returned to pool.");
            }
            this.mFreeConnectionList.push(conn);
        }
    }

    public synchronized void cleanupPool() {
        if (OUTPUT_STATUS) {
            this.log("Cleaning up connection pool.");
        }
        this.mInProgressCleanup = true;
        this.cleanupPoolHelper(this.mFreeConnectionList);
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanupPoolHelper(this.mFreeConnectionList);
        this.cleanupPoolHelper(this.mUsedConnectionList);
        if (OUTPUT_STATUS) {
            this.log("Finished cleaning up\tpool.");
        }
    }

    private synchronized void cleanupPoolHelper(Stack aConnectionStack) {
        if (aConnectionStack != null) {
            while (aConnectionStack.size() > 0) {
                Connection conn = (Connection)aConnectionStack.pop();
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.mInProgressCleanup) {
            this.cleanupPool();
        }
    }

    protected synchronized void log(String message) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Database: " + message, this);
        }
    }

    public String getStatusString() {
        return " freelist: " + this.mFreeConnectionList.size() + "; usedlist: " + this.mUsedConnectionList.size();
    }
}

