/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.ColumnDefinition;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;

public class BooleanColumnDefinition
extends ColumnDefinition {
    public BooleanColumnDefinition(String inColumnName, String inFieldName) {
        super(inColumnName, inFieldName);
    }

    public int getColumnType() {
        return 4;
    }

    public void setFieldFromRow(Field inField, Object inObject, ResultSet inResultSet) {
        try {
            int theValue = inResultSet.getInt(this.getColumnName());
            inField.setBoolean(inObject, theValue == 1);
        }
        catch (Exception e) {
            BooleanColumnDefinition.logError(2, "During setFieldFromRow for " + this.getColumnName(), e);
        }
    }

    public void setRowFromField(Field inField, Object inObject, Hashtable inValues) {
        try {
            boolean theValue = inField.getBoolean(inObject);
            int val = theValue ? 1 : 0;
            inValues.put(this.getColumnName(), "" + val);
        }
        catch (Exception e) {
            BooleanColumnDefinition.logError(2, "During setRowFromField for " + this.getColumnName(), e);
        }
    }

    public void setPreparedStatementValue(Field inField, Object inObject, int inIndex, PreparedStatement inStatement) {
        try {
            boolean theValue = inField.getBoolean(inObject);
            int val = theValue ? 1 : 0;
            inStatement.setInt(inIndex, val);
        }
        catch (Exception e) {
            BooleanColumnDefinition.logError(2, "During setPreparedStatementValue for " + this.getColumnName(), e);
        }
    }
}

