/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.ColumnDefinition;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;

public class BlobColumnDefinition
extends ColumnDefinition {
    public BlobColumnDefinition(String inColumnName, String inFieldName) {
        super(inColumnName, inFieldName);
    }

    public int getColumnType() {
        return 5;
    }

    public void setFieldFromRow(Field inField, Object inObject, ResultSet inResultSet) {
        try {
            int l;
            InputStream inStream = inResultSet.getBinaryStream(this.getColumnName());
            byte[] b = new byte[1024];
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            while ((l = inStream.read(b)) != -1) {
                buffer.write(b, 0, l);
            }
            byte[] theBuffer = buffer.toByteArray();
            inField.set(inObject, theBuffer);
        }
        catch (Exception e) {
            BlobColumnDefinition.logError(2, "During setFieldFromRow for " + this.getColumnName(), e);
        }
    }

    public void setRowFromField(Field inField, Object inObject, Hashtable inValues) {
        try {
            byte[] theValue = (byte[])inField.get(inObject);
            if (theValue != null) {
                inValues.put(this.getColumnName(), new String(theValue));
            } else {
                inValues.put(this.getColumnName(), null);
            }
        }
        catch (Exception e) {
            BlobColumnDefinition.logError(2, "During setRowFromField for " + this.getColumnName(), e);
        }
    }

    public void setPreparedStatementValue(Field inField, Object inObject, int inIndex, PreparedStatement inStatement) {
        try {
            inStatement.setString(inIndex, "empty_blob()");
        }
        catch (Exception e) {
            BlobColumnDefinition.logError(2, "During setPreparedStatementValue for " + this.getColumnName(), e);
        }
    }
}

