/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.rwlock;

import com.raplix.util.message.MessageManager;
import com.raplix.util.rwlock.LockContext;
import com.raplix.util.rwlock.RWLockException;
import java.util.TreeMap;

public class RWLock {
    private TreeMap mLockMsgs = new TreeMap();
    private Long mCurrentWriteLockID = null;
    private int mReaderCount = 0;
    private int mWriterCount = 0;
    private long mLockSeqNum = 0L;
    private static ThreadLocal mLocalData = new ThreadLocal();
    public static final String MSG_PREFIX = "util.rwlock";
    public static final String EX_LOCK_MESSAGE = "util.rwlock.EX_LOCK_MESSAGE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object readLock(Object inMsg, LockContext inCtx) throws Exception {
        RWLock rWLock;
        Long msgKey = null;
        RWLock rWLock2 = this;
        synchronized (rWLock2) {
            if (this.mWriterCount != 0) {
                Long result = (Long)mLocalData.get();
                if (result == null) throw new RWLockException(this.getExceptionMessage(inMsg), this.mLockMsgs.values());
                if (result.longValue() != this.mCurrentWriteLockID.longValue()) {
                    throw new RWLockException(this.getExceptionMessage(inMsg), this.mLockMsgs.values());
                }
                msgKey = this.grantReaderLock(inMsg);
            } else {
                msgKey = this.grantReaderLock(inMsg);
            }
        }
        Object result = null;
        try {
            result = inCtx.execute();
            Object var8_7 = null;
            rWLock = this;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            RWLock rWLock3 = this;
            synchronized (rWLock3) {
                this.releaseReaderLock(msgKey);
                throw throwable;
            }
        }
        synchronized (rWLock) {
            this.releaseReaderLock(msgKey);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object writeLock(Object inMsg, LockContext inCtx) throws Exception {
        RWLock rWLock;
        Long msgKey = null;
        RWLock rWLock2 = this;
        synchronized (rWLock2) {
            if (this.mReaderCount != 0) {
                throw new RWLockException(this.getExceptionMessage(inMsg), this.mLockMsgs.values());
            }
            if (this.mWriterCount == 0) {
                this.mCurrentWriteLockID = msgKey = this.grantWriterLock(inMsg);
                mLocalData.set(msgKey);
            } else {
                Long result = (Long)mLocalData.get();
                if (result != null) {
                    if (result.longValue() != this.mCurrentWriteLockID.longValue()) {
                        throw new RWLockException(this.getExceptionMessage(inMsg), this.mLockMsgs.values());
                    }
                    msgKey = this.grantWriterLock(inMsg);
                } else {
                    throw new RWLockException(this.getExceptionMessage(inMsg), this.mLockMsgs.values());
                }
            }
        }
        Object result = null;
        try {
            result = inCtx.execute();
            Object var8_7 = null;
            rWLock = this;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            RWLock rWLock3 = this;
            synchronized (rWLock3) {
                this.releaseWriterLock(msgKey);
            }
            throw throwable;
        }
        synchronized (rWLock) {
            this.releaseWriterLock(msgKey);
        }
        return result;
    }

    private Long grantReaderLock(Object inMsg) {
        Long tmp = new Long(this.mLockSeqNum++);
        this.mLockMsgs.put(tmp, inMsg);
        ++this.mReaderCount;
        return tmp;
    }

    private Long grantWriterLock(Object inMsg) {
        Long tmp = new Long(this.mLockSeqNum++);
        this.mLockMsgs.put(tmp, inMsg);
        ++this.mWriterCount;
        return tmp;
    }

    private void releaseReaderLock(Long lockID) {
        this.mLockMsgs.remove(lockID);
        --this.mReaderCount;
    }

    private void releaseWriterLock(Long lockID) {
        this.mLockMsgs.remove(lockID);
        --this.mWriterCount;
    }

    private String getExceptionMessage(Object inMsg) {
        Object blockingLock = this.mLockMsgs.get(this.mLockMsgs.lastKey());
        return MessageManager.messageAsString(EX_LOCK_MESSAGE, new Object[]{inMsg.toString(), blockingLock.toString()});
    }
}

