/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.regex;

import com.raplix.util.regex.RegExSyntaxException;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegEx {
    private Pattern mRE;
    private Matcher mLastMatch;

    public RegEx(String pattern) throws RegExSyntaxException {
        try {
            this.mRE = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException rex) {
            throw new RegExSyntaxException(pattern, rex);
        }
    }

    public boolean match(String str) {
        Matcher matchers = this.mRE.matcher(str);
        if (!matchers.find()) {
            return false;
        }
        this.mLastMatch = matchers;
        return true;
    }

    public boolean match(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new UnicodeInputStreamReader(stream));
        String line = "";
        do {
            Matcher matcher;
            if (!(matcher = this.mRE.matcher(line)).find()) continue;
            this.mLastMatch = matcher;
            return true;
        } while ((line = reader.readLine()) != null);
        return false;
    }

    public int getParenCount() {
        if (this.mLastMatch == null) {
            return -1;
        }
        return this.mLastMatch.groupCount() + 1;
    }

    public String getParen(int group) {
        if (this.mLastMatch == null) {
            return null;
        }
        String out = null;
        this.mLastMatch.reset();
        if (this.mLastMatch.find() && this.mLastMatch.groupCount() >= group) {
            out = this.mLastMatch.group(group);
        }
        return out;
    }

    public static boolean match(String pattern, String str) throws RegExSyntaxException {
        return new RegEx(pattern).match(str);
    }

    public static boolean wildcardStartsImprecise(String wildcard) {
        return wildcard.startsWith("*");
    }

    public static boolean wildcardEndsImprecise(String wildcard) {
        return wildcard.endsWith("*");
    }

    public static String createContainedWildcard(String wildcard) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < wildcard.length(); ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                buffer.append(".*");
                continue;
            }
            if (c == '?') {
                buffer.append(".");
                continue;
            }
            if (c == '\\') {
                buffer.append("\\\\");
                continue;
            }
            if (c == '.') {
                buffer.append("\\.");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String createPreciseWildcard(String wildcard) {
        return "^" + RegEx.createContainedWildcard(wildcard) + "$";
    }

    public static String createStrictPreciseWildcard(String wildcard) {
        StringBuffer buffer = new StringBuffer("^");
        block5: for (int i = 0; i < wildcard.length(); ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    buffer.append(".*");
                    continue block5;
                }
                case '?': {
                    buffer.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buffer.append("\\");
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        buffer.append("$");
        return buffer.toString();
    }

    public String[] doMatch(String str) {
        Matcher matchers = this.mRE.matcher(str);
        if (matchers.find()) {
            String[] rest = new String[matchers.groupCount() + 1];
            for (int x = 0; x < matchers.groupCount() + 1; ++x) {
                rest[x] = matchers.group(x);
            }
            return rest;
        }
        return null;
    }

    public String toString() {
        return this.mRE.pattern();
    }
}

