/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.regex;

import com.raplix.util.regex.PackageInfo;
import com.raplix.util.regex.RegEx;
import com.raplix.util.regex.RegExSyntaxException;

public final class REUtil {
    private REUtil() {
    }

    public static RegEx compilePattern(String pattern) {
        try {
            return new RegEx(pattern);
        }
        catch (RegExSyntaxException ex) {
            throw PackageInfo.createMalformedPattern(pattern, ex);
        }
    }

    public static RegEx[] compilePatterns(String[] patterns, boolean upcase) {
        RegEx[] re = new RegEx[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            re[i] = REUtil.compilePattern(upcase ? patterns[i].toUpperCase() : patterns[i]);
        }
        return re;
    }

    public static RegEx compileWildcard(String pattern) {
        return REUtil.compilePattern(RegEx.createPreciseWildcard(pattern));
    }

    public static RegEx[] compileWildcards(String[] patterns, boolean upcase) {
        RegEx[] re = new RegEx[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            re[i] = REUtil.compileWildcard(upcase ? patterns[i].toUpperCase() : patterns[i]);
        }
        return re;
    }
}

