/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.regex;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.regex.RegEx;
import com.raplix.util.regex.RegExSyntaxException;
import com.raplix.util.string.StringUtil;

public class GlobPattern
implements RPCSerializable {
    private String mPattern;
    private String mSQLPattern;
    private transient RegEx mRegEx;

    public static GlobPattern create(String pattern) {
        if (StringUtil.isEmpty(pattern)) {
            return null;
        }
        return new GlobPattern(pattern);
    }

    private GlobPattern(String pattern) {
        this.mPattern = pattern;
    }

    private GlobPattern() {
    }

    public String getPattern() {
        return this.mPattern;
    }

    public String toString() {
        return this.getPattern();
    }

    public int hashCode() {
        return this.getPattern().hashCode();
    }

    public boolean equals(Object other) {
        return other != null && other.getClass().equals(this.getClass()) && ((GlobPattern)other).getPattern().equals(this.getPattern());
    }

    public String toSQLPattern() {
        if (this.mSQLPattern == null) {
            StringBuffer buf = new StringBuffer(this.mPattern);
            int len = buf.length();
            for (int i = 0; i < len; ++i) {
                char ch = buf.charAt(i);
                if (ch == '*') {
                    buf.setCharAt(i, '%');
                    continue;
                }
                if (ch == '?') {
                    buf.setCharAt(i, '_');
                    continue;
                }
                if (ch == '%' || ch == '_' || ch == '\\') {
                    buf.insert(i++, '\\');
                    ++len;
                    continue;
                }
                if (!Character.isUpperCase(ch)) continue;
                buf.setCharAt(i, Character.toLowerCase(ch));
            }
            this.mSQLPattern = buf.toString();
        }
        return this.mSQLPattern;
    }

    public RegEx toRegEx() throws RegExSyntaxException {
        if (this.mRegEx == null) {
            String pattern = RegEx.createStrictPreciseWildcard(this.getPattern().toLowerCase());
            this.mRegEx = new RegEx(pattern);
        }
        return this.mRegEx;
    }
}

