/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.reflect;

import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.reflect";
    public static final String EX_UNKNOWN_CLASS = "util.reflect.EX_UNKNOWN_CLASS";
    public static final String EX_UNEXPECTED_CLASS = "util.reflect.EX_UNEXPECTED_CLASS";
    public static final String EX_CANNOT_INSTANTIATE = "util.reflect.EX_CANNOT_INSTANTIATE";
    public static final String EX_NO_METHOD = "util.reflect.EX_NO_METHOD";
    public static final String EX_NO_FIELD = "util.reflect.EX_NO_FIELD";
    public static final String EX_NO_FIELD_ACCESS = "util.reflect.EX_NO_FIELD_ACCESS";
    public static final String EX_AMBIGUOUS_METHOD = "util.reflect.EX_AMBIGUOUS_METHOD";
    public static final String EX_NO_CONSTRUCTOR = "util.reflect.EX_NO_CONSTRUCTOR";

    private PackageInfo() {
    }

    public static NoClassDefFoundError createUnknownClass(String name, Exception ex) {
        String message = MessageManager.messageAsString(EX_UNKNOWN_CLASS, new Object[]{name, ex.getMessage()});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new NoClassDefFoundError(message);
    }

    public static IllegalArgumentException createUnexpectedClass(Class expected, Class actual) {
        return new IllegalArgumentException(MessageManager.messageAsString(EX_UNEXPECTED_CLASS, new Object[]{actual.getName(), expected.getName()}));
    }

    public static IllegalArgumentException createCannotInstantiate(Constructor c, Exception ex) {
        return PackageInfo.createCannotInstantiate(c.getDeclaringClass(), ex);
    }

    public static IllegalArgumentException createCannotInstantiate(Class cls, Exception ex) {
        String message = MessageManager.messageAsString(EX_CANNOT_INSTANTIATE, new Object[]{cls.getName(), ex.getMessage()});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new IllegalArgumentException(message);
    }

    public static IllegalArgumentException createNoMethod(Class cls, String methodName) {
        return new IllegalArgumentException(MessageManager.messageAsString(EX_NO_METHOD, new Object[]{methodName, cls.getName()}));
    }

    public static IllegalArgumentException createNoField(Class cls, String fieldName) {
        return new IllegalArgumentException(MessageManager.messageAsString(EX_NO_FIELD, new Object[]{fieldName, cls.getName()}));
    }

    public static IllegalArgumentException createNoAccess(Field field) {
        return new IllegalArgumentException(MessageManager.messageAsString(EX_NO_FIELD_ACCESS, new Object[]{field.getName(), field.getClass()}));
    }

    public static IllegalArgumentException createAmbiguousMethod(Class cls, String methodName) {
        return new IllegalArgumentException(MessageManager.messageAsString(EX_AMBIGUOUS_METHOD, new Object[]{methodName, cls.getName()}));
    }

    public static IllegalArgumentException createNoConstructor(Class cls, Exception ex) {
        String message = MessageManager.messageAsString(EX_NO_CONSTRUCTOR, new Object[]{cls.getName(), ex.getMessage()});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new IllegalArgumentException(message);
    }
}

