/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.reflect;

import com.raplix.util.exceptions.ExceptionUtil;
import com.raplix.util.reflect.PackageInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class MethodUtil {
    private MethodUtil() {
    }

    private static Method findMethod(Method[] methods, Class cls, String methodName) {
        Method result = null;
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                if (!methodName.equals(methods[i].getName())) continue;
                if (result != null) {
                    throw PackageInfo.createAmbiguousMethod(cls, methodName);
                }
                result = methods[i];
            }
        }
        return result;
    }

    public static Method findMethod(Class cls, String methodName) {
        Method result = MethodUtil.findMethod(cls.getMethods(), cls, methodName);
        if (result != null) {
            return result;
        }
        result = MethodUtil.findMethod(cls.getDeclaredMethods(), cls, methodName);
        if (result != null) {
            return result;
        }
        throw PackageInfo.createNoMethod(cls, methodName);
    }

    public static Object invoke(Method m, Object receiver, Object[] arguments) throws Exception {
        try {
            return m.invoke(receiver, arguments);
        }
        catch (InvocationTargetException ex) {
            ExceptionUtil.unwrap(ex);
            return null;
        }
    }

    public static Object invokeMember(Method m, Object receiver) throws Exception {
        return MethodUtil.invoke(m, receiver, null);
    }

    public static Object invokeMember(Method m, Object receiver, Object arg0) throws Exception {
        return MethodUtil.invoke(m, receiver, new Object[]{arg0});
    }

    public static Object invokeMember(Method m, Object receiver, Object arg0, Object arg1) throws Exception {
        return MethodUtil.invoke(m, receiver, new Object[]{arg0, arg1});
    }

    public static Object invokeStatic(Method m, Object arg0) throws Exception {
        return MethodUtil.invokeMember(m, null, arg0);
    }

    public static Object invokeStatic(Method m) throws Exception {
        return MethodUtil.invokeMember(m, null);
    }

    public static Object invokeStatic(Method m, Object arg0, Object arg1) throws Exception {
        return MethodUtil.invokeMember(m, null, arg0, arg1);
    }
}

