/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.reflect;

import com.raplix.util.exceptions.ExceptionUtil;
import com.raplix.util.reflect.PackageInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ConstructorUtil {
    private ConstructorUtil() {
    }

    public static Constructor find(Class cls, Class[] arguments) {
        try {
            return cls.getConstructor(arguments);
        }
        catch (NoSuchMethodException ex) {
            try {
                return cls.getDeclaredConstructor(arguments);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            throw PackageInfo.createNoConstructor(cls, ex);
        }
    }

    public static Constructor findConstructor(Class cls) {
        return ConstructorUtil.find(cls, null);
    }

    public static Constructor findConstructor(Class cls, Class arg0) {
        return ConstructorUtil.find(cls, new Class[]{arg0});
    }

    public static Constructor findConstructor(Class cls, Class arg0, Class arg1) {
        return ConstructorUtil.find(cls, new Class[]{arg0, arg1});
    }

    public static Object create(Constructor c, Object[] arguments) throws Exception {
        try {
            return c.newInstance(arguments);
        }
        catch (InvocationTargetException ex) {
            ExceptionUtil.unwrap(ex);
            return null;
        }
        catch (InstantiationException ex) {
            throw PackageInfo.createCannotInstantiate(c, (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw PackageInfo.createCannotInstantiate(c, (Exception)ex);
        }
    }

    public static Object createObject(Constructor c) throws Exception {
        return ConstructorUtil.create(c, null);
    }

    public static Object createObject(Constructor c, Object arg0) throws Exception {
        return ConstructorUtil.create(c, new Object[]{arg0});
    }

    public static Object createObject(Constructor c, Object arg0, Object arg1) throws Exception {
        return ConstructorUtil.create(c, new Object[]{arg0, arg1});
    }
}

