/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.reflect;

import com.raplix.util.reflect.ConstructorUtil;
import com.raplix.util.reflect.PackageInfo;

public final class ClassUtil {
    public static final Class BOOLEAN_OBJ_CLS = Boolean.class;
    public static final Class BOOLEAN_PRM_CLS = Boolean.TYPE;
    public static final String BOOLEAN_OBJ_NAME = BOOLEAN_OBJ_CLS.getName();
    public static final String BOOLEAN_PRM_NAME = BOOLEAN_PRM_CLS.getName();
    public static final char BOOLEAN_ARR_CODE = 'Z';
    public static final Class BYTE_OBJ_CLS = Byte.class;
    public static final Class BYTE_PRM_CLS = Byte.TYPE;
    public static final String BYTE_OBJ_NAME = BYTE_OBJ_CLS.getName();
    public static final String BYTE_PRM_NAME = BYTE_PRM_CLS.getName();
    public static final char BYTE_ARR_CODE = 'B';
    public static final Class CHARACTER_OBJ_CLS = Character.class;
    public static final Class CHARACTER_PRM_CLS = Character.TYPE;
    public static final String CHARACTER_OBJ_NAME = CHARACTER_OBJ_CLS.getName();
    public static final String CHARACTER_PRM_NAME = CHARACTER_PRM_CLS.getName();
    public static final char CHARACTER_ARR_CODE = 'C';
    public static final char CLASS_ARR_CODE = 'L';
    public static final Class DOUBLE_OBJ_CLS = Double.class;
    public static final Class DOUBLE_PRM_CLS = Double.TYPE;
    public static final String DOUBLE_OBJ_NAME = DOUBLE_OBJ_CLS.getName();
    public static final String DOUBLE_PRM_NAME = DOUBLE_PRM_CLS.getName();
    public static final char DOUBLE_ARR_CODE = 'D';
    public static final Class FLOAT_OBJ_CLS = Float.class;
    public static final Class FLOAT_PRM_CLS = Float.TYPE;
    public static final String FLOAT_OBJ_NAME = FLOAT_OBJ_CLS.getName();
    public static final String FLOAT_PRM_NAME = FLOAT_PRM_CLS.getName();
    public static final char FLOAT_ARR_CODE = 'F';
    public static final Class INTEGER_OBJ_CLS = Integer.class;
    public static final Class INTEGER_PRM_CLS = Integer.TYPE;
    public static final String INTEGER_OBJ_NAME = INTEGER_OBJ_CLS.getName();
    public static final String INTEGER_PRM_NAME = INTEGER_PRM_CLS.getName();
    public static final char INTEGER_ARR_CODE = 'I';
    public static final Class LONG_OBJ_CLS = Long.class;
    public static final Class LONG_PRM_CLS = Long.TYPE;
    public static final String LONG_OBJ_NAME = LONG_OBJ_CLS.getName();
    public static final String LONG_PRM_NAME = LONG_PRM_CLS.getName();
    public static final char LONG_ARR_CODE = 'J';
    public static final Class SHORT_OBJ_CLS = Short.class;
    public static final Class SHORT_PRM_CLS = Short.TYPE;
    public static final String SHORT_OBJ_NAME = SHORT_OBJ_CLS.getName();
    public static final String SHORT_PRM_NAME = SHORT_PRM_CLS.getName();
    public static final char SHORT_ARR_CODE = 'S';
    public static final Class VOID_OBJ_CLS = Void.class;
    public static final Class VOID_PRM_CLS = Void.TYPE;
    public static final String VOID_OBJ_NAME = VOID_OBJ_CLS.getName();
    public static final String VOID_PRM_NAME = VOID_PRM_CLS.getName();

    private ClassUtil() {
    }

    public static Class findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw PackageInfo.createUnknownClass(name, ex);
        }
    }

    public static void checkExpected(Class expected, Class actual) {
        if (!expected.isAssignableFrom(actual)) {
            throw PackageInfo.createUnexpectedClass(expected, actual);
        }
    }

    public static Object createObject(Class cls) {
        try {
            return ConstructorUtil.createObject(ConstructorUtil.findConstructor(cls));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw PackageInfo.createCannotInstantiate(cls, ex);
        }
    }

    public static Object createObject(Class cls, Class argCls, Object arg) {
        try {
            return ConstructorUtil.createObject(ConstructorUtil.findConstructor(cls, argCls), arg);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw PackageInfo.createCannotInstantiate(cls, ex);
        }
    }

    public static Object createObject(Class cls, Object arg) {
        return ClassUtil.createObject(cls, arg.getClass(), arg);
    }

    public static Object createObject(Class cls, Object arg0, Object arg1) {
        try {
            return ConstructorUtil.createObject(ConstructorUtil.findConstructor(cls, arg0.getClass(), arg1.getClass()), arg0, arg1);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw PackageInfo.createCannotInstantiate(cls, ex);
        }
    }

    public static Object createObject(Class actual, Class expected) {
        ClassUtil.checkExpected(expected, actual);
        return ClassUtil.createObject(actual);
    }

    public static Object createObject(String name, Class expected) {
        return ClassUtil.createObject(ClassUtil.findClass(name), expected);
    }

    public static String getClassName(String name) {
        int arrayCount = 0;
        while (name.charAt(arrayCount) == '[') {
            ++arrayCount;
        }
        if (arrayCount == 0) {
            return ClassUtil.getObjectName(name);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(ClassUtil.getElementName(name.substring(arrayCount)));
        for (int i = 0; i < arrayCount; ++i) {
            buffer.append("Array");
        }
        return buffer.toString();
    }

    public static String getElementName(String code) {
        switch (code.charAt(0)) {
            case 'Z': {
                return BOOLEAN_OBJ_NAME;
            }
            case 'B': {
                return BYTE_OBJ_NAME;
            }
            case 'C': {
                return CHARACTER_OBJ_NAME;
            }
            case 'L': {
                return code.substring(1, code.length() - 1);
            }
            case 'D': {
                return DOUBLE_OBJ_NAME;
            }
            case 'F': {
                return FLOAT_OBJ_NAME;
            }
            case 'I': {
                return INTEGER_OBJ_NAME;
            }
            case 'J': {
                return LONG_OBJ_NAME;
            }
            case 'S': {
                return SHORT_OBJ_NAME;
            }
        }
        return code;
    }

    public static String getClassName(Class cls) {
        String name = ClassUtil.getClassName(cls.getName());
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    public static String getObjectName(String name) {
        if (BOOLEAN_PRM_NAME.equals(name)) {
            return BOOLEAN_OBJ_NAME;
        }
        if (BYTE_PRM_NAME.equals(name)) {
            return BYTE_OBJ_NAME;
        }
        if (CHARACTER_PRM_NAME.equals(name)) {
            return CHARACTER_OBJ_NAME;
        }
        if (DOUBLE_PRM_NAME.equals(name)) {
            return DOUBLE_OBJ_NAME;
        }
        if (FLOAT_PRM_NAME.equals(name)) {
            return FLOAT_OBJ_NAME;
        }
        if (INTEGER_PRM_NAME.equals(name)) {
            return INTEGER_OBJ_NAME;
        }
        if (LONG_PRM_NAME.equals(name)) {
            return LONG_OBJ_NAME;
        }
        if (SHORT_PRM_NAME.equals(name)) {
            return SHORT_OBJ_NAME;
        }
        if (VOID_PRM_NAME.equals(name)) {
            return VOID_OBJ_NAME;
        }
        return name;
    }

    public static Class getObjectClass(Class cls) {
        if (!cls.isPrimitive()) {
            return cls;
        }
        if (cls.equals(BOOLEAN_PRM_CLS)) {
            return BOOLEAN_OBJ_CLS;
        }
        if (cls.equals(BYTE_PRM_CLS)) {
            return BYTE_OBJ_CLS;
        }
        if (cls.equals(CHARACTER_PRM_CLS)) {
            return CHARACTER_OBJ_CLS;
        }
        if (cls.equals(DOUBLE_PRM_CLS)) {
            return DOUBLE_OBJ_CLS;
        }
        if (cls.equals(FLOAT_PRM_CLS)) {
            return FLOAT_OBJ_CLS;
        }
        if (cls.equals(INTEGER_PRM_CLS)) {
            return INTEGER_OBJ_CLS;
        }
        if (cls.equals(LONG_PRM_CLS)) {
            return LONG_OBJ_CLS;
        }
        if (cls.equals(SHORT_PRM_CLS)) {
            return SHORT_OBJ_CLS;
        }
        if (cls.equals(VOID_PRM_CLS)) {
            return VOID_OBJ_CLS;
        }
        return null;
    }

    public static Class getPrimitiveClass(Class cls) {
        if (cls.isPrimitive()) {
            return cls;
        }
        if (cls.equals(BOOLEAN_OBJ_CLS)) {
            return BOOLEAN_PRM_CLS;
        }
        if (cls.equals(BYTE_OBJ_CLS)) {
            return BYTE_PRM_CLS;
        }
        if (cls.equals(CHARACTER_OBJ_CLS)) {
            return CHARACTER_PRM_CLS;
        }
        if (cls.equals(DOUBLE_OBJ_CLS)) {
            return DOUBLE_PRM_CLS;
        }
        if (cls.equals(FLOAT_OBJ_CLS)) {
            return FLOAT_PRM_CLS;
        }
        if (cls.equals(INTEGER_OBJ_CLS)) {
            return INTEGER_PRM_CLS;
        }
        if (cls.equals(LONG_OBJ_CLS)) {
            return LONG_PRM_CLS;
        }
        if (cls.equals(SHORT_OBJ_CLS)) {
            return SHORT_PRM_CLS;
        }
        if (cls.equals(VOID_OBJ_CLS)) {
            return VOID_PRM_CLS;
        }
        return null;
    }
}

