/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.proxy;

import com.raplix.util.proxy.ProxyManager;
import com.sun.n1.sps.client.CommandException;
import com.sun.n1.sps.client.ConversionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;

class ProxyMapping {
    private Class mPrivateClass;
    private Class mPublicClass;
    private Class mProxyClass;
    private ProxyManager mProxyMgr;
    private HashMap mMethodCache = new HashMap();

    ProxyMapping(Class inPublicClass, Class inPrivateClass, ProxyManager inProxyMgr) {
        this.mProxyMgr = inProxyMgr;
        this.mPublicClass = inPublicClass;
        this.mPrivateClass = inPrivateClass;
        this.mProxyClass = Proxy.getProxyClass(inProxyMgr.getLoader(), inPublicClass);
    }

    private synchronized Method mapMethod(Method inPublicMethod) throws ConversionException {
        Method thePrivateMethod = (Method)this.mMethodCache.get(inPublicMethod);
        if (thePrivateMethod == null) {
            Class<?>[] theParams = inPublicMethod.getParameterTypes();
            for (int i = 0; i < theParams.length; ++i) {
                theParams[i] = this.mProxyMgr.publicToPrivateClass(theParams[i]);
            }
            try {
                thePrivateMethod = this.mPrivateClass.getMethod(inPublicMethod.getName(), theParams);
            }
            catch (Throwable e) {
                throw new ConversionException(e);
            }
            this.mMethodCache.put(inPublicMethod, thePrivateMethod);
        }
        return thePrivateMethod;
    }

    Object invoke(Object inPrivateImpl, Method inMethod, Object[] inArgs) throws ConversionException, CommandException {
        Object thePrivateObject;
        Object[] thePrivateArgs = inArgs;
        if (inArgs != null) {
            for (int i = 0; i < inArgs.length; ++i) {
                thePrivateArgs[i] = this.mProxyMgr.publicToPrivateInstance(inArgs[i]);
            }
        }
        Method thePrivateMethod = this.mapMethod(inMethod);
        try {
            thePrivateObject = thePrivateMethod.invoke(inPrivateImpl, thePrivateArgs);
        }
        catch (IllegalArgumentException e) {
            throw new CommandException(e);
        }
        catch (InvocationTargetException e) {
            throw new CommandException(e);
        }
        catch (Throwable t) {
            throw new CommandException(t);
        }
        return this.mProxyMgr.privateToPublicInstance(thePrivateObject);
    }

    Class getImplClass() {
        return this.mPrivateClass;
    }

    Class getIfaceClass() {
        return this.mPublicClass;
    }

    Class getProxyClass() {
        return this.mProxyClass;
    }
}

