/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.proxy;

import com.raplix.util.message.MessageManager;
import com.raplix.util.proxy.EnumConverter;
import com.raplix.util.proxy.InterfaceConverter;
import com.raplix.util.proxy.ProxyConverter;
import com.raplix.util.proxy.StreamConverter;
import com.sun.n1.sps.client.ConversionException;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class ProxyManager {
    public static final String MSG_LOADER_NOT_NULLABLE = "util.proxy.LOADER_NOT_NULLABLE";
    public static final String MSG_PARAMS_NOT_NULLABLE = "util.proxy.PARAMS_NOT_NULLABLE";
    public static final String MSG_ARRAYS_DISALLOWED = "util.proxy.ARRAYS_DISALLOWED";
    public static final String MSG_PRIVATE_PRIMITIVES_DISALLOWED = "util.proxy.PRIVATE_PRIMITIVES_DISALLOWED";
    public static final String MSG_NO_CONVERTER = "util.proxy.NO_CONVERTER";
    public static final String MSG_PUBLIC_ALREADY_REG = "util.proxy.PUBLIC_ALREADY_REG";
    public static final String MSG_PRIVATE_ALREADY_REG = "util.proxy.PRIVATE_ALREADY_REG";
    private ClassLoader mLoader;
    private ProxyConverter[] mConverters = new ProxyConverter[]{new EnumConverter(this), new StreamConverter(this), new InterfaceConverter(this)};
    private Map mConvertDataByPublicClass = new HashMap();
    private Map mConvertDataByPrivateClass = new HashMap();
    private Map mConvertDataByProxyClass = new HashMap();

    public ProxyManager() {
        this(ClassLoader.getSystemClassLoader());
    }

    public ProxyManager(ClassLoader loader) {
        this.setLoader(loader);
        for (int i = 0; i < this.mConverters.length; ++i) {
            this.mConverters[i].initFinish();
        }
    }

    public ClassLoader getLoader() {
        return this.mLoader;
    }

    private void setLoader(ClassLoader inLoader) {
        if (inLoader == null) {
            throw new NullPointerException(MessageManager.messageAsString(MSG_LOADER_NOT_NULLABLE));
        }
        this.mLoader = inLoader;
    }

    public synchronized void register(Class inPublicClass, Class inPrivateClass) {
        if (inPublicClass == null || inPrivateClass == null) {
            throw new IllegalArgumentException(MessageManager.messageAsString(MSG_PARAMS_NOT_NULLABLE));
        }
        if (inPublicClass.isArray() || inPrivateClass.isArray()) {
            throw new IllegalArgumentException(MessageManager.messageAsString(MSG_ARRAYS_DISALLOWED));
        }
        if (inPrivateClass.isPrimitive()) {
            throw new IllegalArgumentException(MessageManager.messageAsString(MSG_PRIVATE_PRIMITIVES_DISALLOWED));
        }
        ProxyConverter theProxyConverter = null;
        for (int i = 0; i < this.mConverters.length; ++i) {
            if (!this.mConverters[i].isConverterFor(inPublicClass, inPrivateClass)) continue;
            theProxyConverter = this.mConverters[i];
            break;
        }
        if (theProxyConverter == null) {
            throw new IllegalArgumentException(MessageManager.messageAsString(MSG_NO_CONVERTER, new Object[]{inPublicClass.getName(), inPrivateClass.getName()}));
        }
        MoreData theMoreData = theProxyConverter.register(inPublicClass, inPrivateClass);
        Class theProxyClass = null;
        Object thePrivateData = null;
        if (theMoreData != null) {
            thePrivateData = theMoreData.mPrivateData;
            theProxyClass = theMoreData.mProxyClass;
        }
        boolean isPublicToPrivateOnly = false;
        this.register(theProxyConverter, inPublicClass, inPrivateClass, theProxyClass, thePrivateData, isPublicToPrivateOnly);
    }

    protected void initFinishRegister(Class inPublicClass, Class inPrivateClass, ProxyConverter inConverter, boolean inPublicToPrivateOnly) {
        this.register(inConverter, inPublicClass, inPrivateClass, null, null, inPublicToPrivateOnly);
    }

    private void register(ProxyConverter inConverter, Class inPublicClass, Class inPrivateClass, Class inProxyClass, Object inPrivateData, boolean inPublicToPrivateOnly) {
        if (this.mConvertDataByPublicClass.get(inPublicClass) != null) {
            throw new IllegalArgumentException(MessageManager.messageAsString(MSG_PUBLIC_ALREADY_REG, new Object[]{inPublicClass.getName()}));
        }
        if (this.mConvertDataByPrivateClass.get(inPrivateClass) != null) {
            throw new IllegalArgumentException(MessageManager.messageAsString(MSG_PRIVATE_ALREADY_REG, new Object[]{inPrivateClass.getName()}));
        }
        ConvertData theConvertData = new ConvertData(inConverter, inPublicClass, inPrivateClass, inProxyClass, inPrivateData, inPublicToPrivateOnly);
        this.mConvertDataByPublicClass.put(inPublicClass, theConvertData);
        if (!inPublicToPrivateOnly) {
            this.mConvertDataByPrivateClass.put(inPrivateClass, theConvertData);
        }
        if (inProxyClass != null) {
            this.mConvertDataByProxyClass.put(inProxyClass, theConvertData);
        }
    }

    protected Class getMappedPublicClass(Class inPrivateClass) {
        ConvertData theConvertData = (ConvertData)this.mConvertDataByPrivateClass.get(inPrivateClass);
        if (theConvertData == null) {
            return null;
        }
        return theConvertData.getPublicClass();
    }

    protected Class getMappedPrivateClass(Class inPublicClass) {
        ConvertData theConvertData = (ConvertData)this.mConvertDataByPublicClass.get(inPublicClass);
        if (theConvertData == null) {
            return null;
        }
        return theConvertData.getPrivateClass();
    }

    private synchronized ProxyConverter getConverterForPublic(Class inPublicClass) {
        ConvertData theConvertData = null;
        if (Proxy.isProxyClass(inPublicClass)) {
            theConvertData = (ConvertData)this.mConvertDataByProxyClass.get(inPublicClass);
        } else {
            theConvertData = (ConvertData)this.mConvertDataByPublicClass.get(inPublicClass);
            if (theConvertData == null) {
                for (int i = 0; i < this.mConverters.length; ++i) {
                    Class theAltPublicClass = this.mConverters[i].findAlternativeForPublic(inPublicClass);
                    if (theAltPublicClass == null) continue;
                    theConvertData = (ConvertData)this.mConvertDataByPublicClass.get(theAltPublicClass);
                    this.mConvertDataByPublicClass.put(inPublicClass, theConvertData);
                    return theConvertData.getConverter();
                }
            }
        }
        if (theConvertData != null) {
            return theConvertData.getConverter();
        }
        return null;
    }

    private synchronized ProxyConverter getConverterForPrivate(Class inPrivateClass) {
        ConvertData theConvertData = (ConvertData)this.mConvertDataByPrivateClass.get(inPrivateClass);
        if (theConvertData != null) {
            return theConvertData.getConverter();
        }
        for (int i = 0; i < this.mConverters.length; ++i) {
            Class theAltPrivateClass = this.mConverters[i].findAlternativeForPrivate(inPrivateClass);
            if (theAltPrivateClass == null) continue;
            theConvertData = (ConvertData)this.mConvertDataByPrivateClass.get(theAltPrivateClass);
            this.mConvertDataByPrivateClass.put(inPrivateClass, theConvertData);
            return theConvertData.getConverter();
        }
        return null;
    }

    public Object privateToPublicInstance(Object inPrivateObject) throws ConversionException {
        if (inPrivateObject == null) {
            return null;
        }
        if (inPrivateObject.getClass().isArray()) {
            Class<?> thePrivateArrayElemClass = inPrivateObject.getClass().getComponentType();
            int theNumDimensions = 1;
            while (true) {
                if (thePrivateArrayElemClass.isPrimitive()) {
                    return inPrivateObject;
                }
                if (!thePrivateArrayElemClass.isArray()) break;
                ++theNumDimensions;
                thePrivateArrayElemClass = thePrivateArrayElemClass.getComponentType();
            }
            int[] theDimensions = new int[theNumDimensions];
            theDimensions[0] = Array.getLength(inPrivateObject);
            ConvertData theConvertData = (ConvertData)this.mConvertDataByPrivateClass.get(thePrivateArrayElemClass);
            Object[] theConvertedArray = theConvertData == null ? (Object[])Array.newInstance(thePrivateArrayElemClass, theDimensions) : (Object[])Array.newInstance(theConvertData.getPublicClass(), theDimensions);
            for (int i = 0; i < theConvertedArray.length; ++i) {
                theConvertedArray[i] = this.privateToPublicInstance(Array.get(inPrivateObject, i));
            }
            return theConvertedArray;
        }
        ProxyConverter theConverter = this.getConverterForPrivate(inPrivateObject.getClass());
        if (theConverter == null) {
            return inPrivateObject;
        }
        return theConverter.privateToPublicInstance(inPrivateObject);
    }

    public Object publicToPrivateInstance(Object inPublicObject) throws ConversionException {
        if (inPublicObject == null) {
            return null;
        }
        if (inPublicObject.getClass().isArray()) {
            Class<?> thePublicArrayElemClass = inPublicObject.getClass().getComponentType();
            int theNumDimensions = 1;
            while (true) {
                if (thePublicArrayElemClass.isPrimitive()) {
                    return inPublicObject;
                }
                if (!thePublicArrayElemClass.isArray()) break;
                ++theNumDimensions;
                thePublicArrayElemClass = thePublicArrayElemClass.getComponentType();
            }
            int[] theDimensions = new int[theNumDimensions];
            theDimensions[0] = Array.getLength(inPublicObject);
            ConvertData theConvertData = (ConvertData)this.mConvertDataByPublicClass.get(thePublicArrayElemClass);
            Object[] theConvertedArray = theConvertData == null ? (Object[])Array.newInstance(thePublicArrayElemClass, theDimensions) : (Object[])Array.newInstance(theConvertData.getPrivateClass(), theDimensions);
            for (int i = 0; i < theConvertedArray.length; ++i) {
                theConvertedArray[i] = this.publicToPrivateInstance(Array.get(inPublicObject, i));
            }
            return theConvertedArray;
        }
        ProxyConverter theConverter = this.getConverterForPublic(inPublicObject.getClass());
        if (theConverter == null) {
            return inPublicObject;
        }
        return theConverter.publicToPrivateInstance(inPublicObject);
    }

    public Class publicToPrivateClass(Class inPublicClass) {
        Class thePrivateClass = this.getMappedPrivateClass(inPublicClass);
        if (thePrivateClass == null) {
            return inPublicClass;
        }
        return thePrivateClass;
    }

    ConvertData getConvertDataByPrivate(Class inPrivateClass) {
        return (ConvertData)this.mConvertDataByPrivateClass.get(inPrivateClass);
    }

    ConvertData getConvertDataByProxy(Class inProxyClass) {
        return (ConvertData)this.mConvertDataByProxyClass.get(inProxyClass);
    }

    static class ConvertData {
        private Class mPublicClass;
        private Class mPrivateClass;
        private Class mProxyClass;
        private Object mPrivateData;
        private ProxyConverter mProxyConverter;
        private boolean mPublicToPrivateOnly;

        ConvertData(ProxyConverter inProxyConverter, Class inPublicClass, Class inPrivateClass, Class inProxyClass, Object inPrivateData, boolean inPublicToPrivateOnly) {
            this.mProxyConverter = inProxyConverter;
            this.mPublicClass = inPublicClass;
            this.mPrivateClass = inPrivateClass;
            this.mProxyClass = inProxyClass;
            this.mPrivateData = inPrivateData;
            this.mPublicToPrivateOnly = inPublicToPrivateOnly;
        }

        Class getPublicClass() {
            return this.mPublicClass;
        }

        Class getPrivateClass() {
            return this.mPrivateClass;
        }

        Class getProxyClass() {
            return this.mProxyClass;
        }

        Object getPrivateData() {
            return this.mPrivateData;
        }

        ProxyConverter getConverter() {
            return this.mProxyConverter;
        }
    }

    static class MoreData {
        public Class mProxyClass;
        public Object mPrivateData;

        MoreData(Class inProxyClass, Object inPrivateData) {
            this.mProxyClass = inProxyClass;
            this.mPrivateData = inPrivateData;
        }
    }
}

