/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.proxy;

import com.raplix.util.message.MessageManager;
import com.raplix.util.proxy.ProxyMapping;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class ProxyInvocationHandler
implements InvocationHandler {
    public static final String MSG_IMPL_NOT_NULLABLE = "util.proxy.IMPL_NOT_NULLABLE";
    public static final String MSG_PROXYMAPPING_NOT_NULLABLE = "util.proxy.PROXYMAPPING_NOT_NULLABLE";
    private Object mImpl;
    private ProxyMapping mProxyMapping;

    ProxyInvocationHandler(Object impl, ProxyMapping inProxyMapping) {
        if (impl == null) {
            throw new NullPointerException(MessageManager.messageAsString(MSG_IMPL_NOT_NULLABLE));
        }
        if (inProxyMapping == null) {
            throw new NullPointerException(MessageManager.messageAsString(MSG_PROXYMAPPING_NOT_NULLABLE));
        }
        this.mImpl = impl;
        this.mProxyMapping = inProxyMapping;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.mProxyMapping.invoke(this.mImpl, method, args);
    }

    Object getImpl() {
        return this.mImpl;
    }
}

