/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.proxy;

import com.raplix.util.proxy.ProxyConverter;
import com.raplix.util.proxy.ProxyInvocationHandler;
import com.raplix.util.proxy.ProxyManager;
import com.raplix.util.proxy.ProxyMapping;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

class InterfaceConverter
extends ProxyConverter {
    InterfaceConverter(ProxyManager inProxyMgr) {
        super(inProxyMgr);
    }

    synchronized ProxyManager.MoreData register(Class inPublicClass, Class inPrivateClass) {
        ProxyMapping theMapping = new ProxyMapping(inPublicClass, inPrivateClass, this.mProxyMgr);
        return new ProxyManager.MoreData(theMapping.getProxyClass(), theMapping);
    }

    boolean isConverterFor(Class inPublicClass, Class inPrivateClass) {
        if (inPublicClass.isInterface() && this.isRaplixOrSunSpace(inPrivateClass)) {
            return true;
        }
        String thePublicClassName = inPublicClass.getName();
        return inPublicClass.isInterface() && thePublicClassName.indexOf(".test.") != -1;
    }

    private boolean isRaplixOrSunSpace(Class inClass) {
        String theName = inClass.getName();
        return theName.startsWith("com.raplix.") || theName.startsWith("com.sun.");
    }

    protected Object privateToPublicInstanceSelf(Object inPrivateObject) {
        Class<?> thePrivateClass = inPrivateObject.getClass();
        ProxyMapping theMapping = this.getMappingByImpl(thePrivateClass);
        ProxyInvocationHandler theHandler = new ProxyInvocationHandler(inPrivateObject, theMapping);
        return Proxy.newProxyInstance(this.mProxyMgr.getLoader(), new Class[]{theMapping.getIfaceClass()}, (InvocationHandler)theHandler);
    }

    Class findAlternativeForPrivate(Class inPrivateClass) {
        if (this.isRaplixOrSunSpace(inPrivateClass)) {
            Class<?>[] theInterfaces = inPrivateClass.getInterfaces();
            for (int i = 0; i < theInterfaces.length; ++i) {
                if (!this.isRaplixOrSunSpace(theInterfaces[i]) || this.mProxyMgr.getConvertDataByPrivate(theInterfaces[i]) == null) continue;
                return theInterfaces[i];
            }
            if (!inPrivateClass.isInterface()) {
                for (Class theSuperClass = inPrivateClass.getSuperclass(); theSuperClass != null && this.isRaplixOrSunSpace(theSuperClass); theSuperClass = theSuperClass.getSuperclass()) {
                    if (this.mProxyMgr.getConvertDataByPrivate(theSuperClass) == null) continue;
                    return theSuperClass;
                }
            }
        }
        return null;
    }

    protected Object publicToPrivateInstanceSelf(Object proxy) {
        ProxyMapping mapping = this.getMappingByProxy(proxy.getClass());
        if (mapping == null) {
            return proxy;
        }
        ProxyInvocationHandler theHandler = (ProxyInvocationHandler)Proxy.getInvocationHandler(proxy);
        return theHandler.getImpl();
    }

    private ProxyMapping getMappingByImpl(Class inPrivateClass) {
        ProxyManager.ConvertData theData = this.mProxyMgr.getConvertDataByPrivate(inPrivateClass);
        if (theData != null) {
            return (ProxyMapping)theData.getPrivateData();
        }
        return null;
    }

    private ProxyMapping getMappingByProxy(Class inProxyClass) {
        ProxyManager.ConvertData theData = this.mProxyMgr.getConvertDataByProxy(inProxyClass);
        if (theData != null) {
            return (ProxyMapping)theData.getPrivateData();
        }
        return null;
    }
}

