/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.proxy;

import com.raplix.util.enum.Enum;
import com.raplix.util.proxy.ProxyConverter;
import com.raplix.util.proxy.ProxyManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class EnumConverter
extends ProxyConverter {
    EnumConverter(ProxyManager inProxyMgr) {
        super(inProxyMgr);
    }

    boolean isConverterFor(Class inPublicClass, Class inPrivateClass) {
        return this.isPublicEnum(inPublicClass) && this.isPrivateEnum(inPublicClass);
    }

    protected Object privateToPublicInstanceSelf(Object inPrivateObject) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class thePublicClass = this.mProxyMgr.getMappedPublicClass(inPrivateObject.getClass());
        if (thePublicClass == null) {
            return null;
        }
        return this.convert(inPrivateObject, thePublicClass);
    }

    protected Object publicToPrivateInstanceSelf(Object inPublicObject) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class thePrivateClass = this.mProxyMgr.getMappedPrivateClass(inPublicObject.getClass());
        return this.convert(inPublicObject, thePrivateClass);
    }

    private Object convert(Object inObject, Class inTargetClass) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String enumType = inObject.toString();
        Field factoryField = inTargetClass.getField("FACTORY");
        Object factory = factoryField.get(null);
        Method m = factory.getClass().getMethod("get", String.class);
        Object o = m.invoke(factory, enumType);
        return o;
    }

    private boolean isPublicEnum(Class inClass) {
        return com.sun.n1.util.enum.Enum.class.isAssignableFrom(inClass);
    }

    private boolean isPrivateEnum(Class inClass) {
        return Enum.class.isAssignableFrom(inClass) || this.isPublicEnum(inClass);
    }
}

