/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.windows;

import com.raplix.rolloutexpress.node.bootstrap.VersionComparator;
import com.raplix.util.ClassLoaderFactory;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.windows.PackageInfo;
import com.raplix.util.platform.windows.WindowsServicesException;
import com.raplix.util.regex.RegEx;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Vector;

public abstract class WindowsServices {
    private static WindowsServices sServices = null;
    private static String sHomeDir;
    private static String sDLLDir;
    private static final String JACO_UTIL_INTEG_CLASS = "com.raplix.util.platform.win32.jacozoom.JacoUtilWinServicesIntegrator";
    private static final String JACO_UTIL_CLASS = "com.raplix.util.platform.win32.jacozoom.JacoUtil";
    private static final String WINDOWS_SERVICES_IMPL_CLASS = "com.raplix.util.platform.win32.WindowsServicesImpl";

    public static synchronized WindowsServices getInstance() throws WindowsServicesException {
        if (!PlatformUtil.isWin32()) {
            throw PackageInfo.createCannotGetInstance();
        }
        if (sServices != null) {
            return sServices;
        }
        sServices = WindowsServices.getWinServicesInstance();
        return sServices;
    }

    private static synchronized WindowsServices getWinServicesInstance() throws WindowsServicesException {
        if (!PlatformUtil.isWin32()) {
            throw PackageInfo.createCannotGetInstance();
        }
        Class<?> mainClass = null;
        sHomeDir = System.getProperty("rox_home_dir");
        try {
            File libDir;
            String winutilsDir = System.getProperty("rox_winutils_dir");
            if (winutilsDir != null) {
                sHomeDir = winutilsDir;
            }
            if (!((libDir = new File(new File(new File(sHomeDir, "lib"), "platform"), "win32").getCanonicalFile()).exists() && libDir.isDirectory() || !Logger.isErrorEnabled(WindowsServices.class))) {
                Logger.error(libDir + " is not a valid CenterRun installation directory", WindowsServices.class);
            }
            ClassLoader loader = ClassLoaderFactory.createLoader(libDir, WindowsServices.class.getClassLoader());
            WindowsServices.registerJacoUtil(loader);
            WindowsServices.loadJacoLib(loader);
            mainClass = loader.loadClass(WINDOWS_SERVICES_IMPL_CLASS);
            return (WindowsServices)mainClass.newInstance();
        }
        catch (IOException ioe) {
            throw PackageInfo.createCannotLoadClass(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw PackageInfo.createCannotLoadClass(cnfe);
        }
        catch (InstantiationException ine) {
            throw PackageInfo.createCannotLoadClass(ine);
        }
        catch (IllegalAccessException iae) {
            throw PackageInfo.createCannotLoadClass(iae);
        }
    }

    private static void registerJacoUtil(ClassLoader loader) throws WindowsServicesException {
        try {
            Class<?> regClass = loader.loadClass(JACO_UTIL_INTEG_CLASS);
            Method registerMethod = regClass.getDeclaredMethod("register", new Class[0]);
            if (!Modifier.isStatic(registerMethod.getModifiers()) || !registerMethod.getReturnType().equals(Void.TYPE)) {
                throw PackageInfo.createCannotRegister();
            }
            registerMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            throw PackageInfo.createCannotRegister(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw PackageInfo.createCannotRegister(nsme);
        }
        catch (IllegalAccessException ilae) {
            throw PackageInfo.createCannotRegister(ilae);
        }
        catch (InvocationTargetException ite) {
            throw PackageInfo.createCannotRegister(ite);
        }
    }

    private static void loadJacoLib(ClassLoader loader) throws WindowsServicesException {
        try {
            Class<?> regClass = loader.loadClass(JACO_UTIL_CLASS);
            Method loadMethod = regClass.getDeclaredMethod("loadLibrary", new Class[0]);
            if (!Modifier.isStatic(loadMethod.getModifiers()) || !loadMethod.getReturnType().equals(Void.TYPE)) {
                throw PackageInfo.createCannotLoadJacoBin();
            }
            loadMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            throw PackageInfo.createCannotLoadJacoBin(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw PackageInfo.createCannotLoadJacoBin(nsme);
        }
        catch (IllegalAccessException ilae) {
            throw PackageInfo.createCannotLoadJacoBin(ilae);
        }
        catch (InvocationTargetException ite) {
            throw PackageInfo.createCannotLoadJacoBin(ite);
        }
    }

    public static String getUpgradeLibraryPath(String libraryPath) {
        String returnValue;
        String dllDir = sDLLDir != null ? sDLLDir : sHomeDir;
        File commonUpgradeDir = new File(new File(new File(new File(dllDir, "lib"), "platform"), "win32"), "upgrade");
        libraryPath = libraryPath + PlatformUtil.getLibrarySuffix();
        if (Logger.isDebugEnabled(WindowsServices.class)) {
            Logger.debug("looking for :" + libraryPath + "in the directory- " + commonUpgradeDir.getName(), WindowsServices.class);
        }
        if ((returnValue = WindowsServices.searchForUpgradeLibrary(commonUpgradeDir, libraryPath)) != null) {
            return returnValue;
        }
        File fileName = new File(new File(new File(new File(dllDir, "lib"), "platform"), "win32"), libraryPath);
        return fileName.getAbsolutePath();
    }

    private static void setDLLPath(String path) {
        sDLLDir = path;
    }

    private static String searchForUpgradeLibrary(File searchDir, String libraryPath) {
        if (searchDir != null && searchDir.exists()) {
            File[] upgrades = searchDir.listFiles(ClassLoaderFactory.UpgradeDirFilter.INSTANCE);
            if (upgrades == null) {
                if (Logger.isDebugEnabled(WindowsServices.class)) {
                    Logger.debug("Unable to list files in " + searchDir.getAbsolutePath(), WindowsServices.class);
                }
                return null;
            }
            Arrays.sort(upgrades, VersionComparator.INVERSE_INSTANCE);
            libraryPath = new File(libraryPath).getName();
            for (int i = 0; i < upgrades.length; ++i) {
                File upgradeLib = new File(upgrades[i], libraryPath);
                if (Logger.isDebugEnabled(class$com$raplix$util$platform$windows$WindowsServices == null ? WindowsServices.class$("com.raplix.util.platform.windows.WindowsServices") : class$com$raplix$util$platform$windows$WindowsServices)) {
                    Logger.debug("checking for :" + upgradeLib, class$com$raplix$util$platform$windows$WindowsServices == null ? WindowsServices.class$("com.raplix.util.platform.windows.WindowsServices") : class$com$raplix$util$platform$windows$WindowsServices);
                }
                if (!upgradeLib.exists() || !upgradeLib.isFile()) continue;
                return upgradeLib.getAbsolutePath();
            }
        }
        return null;
    }

    public abstract Vector getProcessInfo(RegEx var1);

    public abstract void doReboot() throws Exception;

    public abstract String[] getEnvironInfo() throws InterruptedException;

    public abstract long getDriveFreeSpace(File var1);

    public abstract File[] getDrivesInfo();

    public abstract String deleteFile(File var1);
}

