/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.windows;

import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.windows.WindowsServicesException;

public final class PackageInfo {
    public static final String MSG_PREFIX = "util.platform.windows";
    public static final String EX_CANNOT_INSTANTIATE = "util.platform.windows.EX_CANNOT_INSTANTIATE";
    public static final String EX_CANNOT_LOAD = "util.platform.windows.EX_CANNOT_LOAD";
    public static final String EX_CANNOT_REGISTER = "util.platform.windows.EX_CANNOT_REGISTER";
    public static final String EX_CANT_REGISTER_METHOD_NOTFOUND = "util.platform.windows.EX_CANT_REGISTER_METHOD_NOTFOUND";
    public static final String EX_CANNOT_LOAD_JACOBIN = "util.platform.windows.EX_CANNOT_LOAD_JACOBIN";
    public static final String EX_CANT_LOAD_METHOD_NOTFOUND = "util.platform.windows.EX_CANT_LOAD_METHOD_NOTFOUND";

    private PackageInfo() {
    }

    public static WindowsServicesException createCannotGetInstance() {
        String message = MessageManager.messageAsString(EX_CANNOT_INSTANTIATE, new Object[]{PlatformUtil.OS_NAME});
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, PackageInfo.class);
        }
        return new WindowsServicesException(message);
    }

    public static WindowsServicesException createCannotLoadClass(Exception ex) {
        String message = MessageManager.messageAsString(EX_CANNOT_LOAD);
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new WindowsServicesException(message, ex);
    }

    public static WindowsServicesException createCannotRegister(Exception ex) {
        String message = MessageManager.messageAsString(EX_CANNOT_REGISTER);
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new WindowsServicesException(message, ex);
    }

    public static WindowsServicesException createCannotRegister() {
        String message = MessageManager.messageAsString(EX_CANT_REGISTER_METHOD_NOTFOUND);
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, PackageInfo.class);
        }
        return new WindowsServicesException(message);
    }

    public static WindowsServicesException createCannotLoadJacoBin(Exception ex) {
        String message = MessageManager.messageAsString(EX_CANNOT_LOAD_JACOBIN);
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, ex, PackageInfo.class);
        }
        return new WindowsServicesException(message, ex);
    }

    public static WindowsServicesException createCannotLoadJacoBin() {
        String message = MessageManager.messageAsString(EX_CANT_LOAD_METHOD_NOTFOUND);
        if (Logger.isDebugEnabled(PackageInfo.class)) {
            Logger.debug(message, PackageInfo.class);
        }
        return new WindowsServicesException(message);
    }
}

