/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.posix;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.NativeLoader;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.PackageInfo;
import com.raplix.util.platform.posix.PosixException;

public class Stat {
    public static final long FMT;
    public static final long RWXU;
    public static final long RUSR;
    public static final long WUSR;
    public static final long XUSR;
    public static final long RWXG;
    public static final long RGRP;
    public static final long WGRP;
    public static final long XGRP;
    public static final long RWXO;
    public static final long ROTH;
    public static final long WOTH;
    public static final long XOTH;
    public static final long SUID;
    public static final long SGID;
    public static final long SVTX;
    private static long sFMT;
    private static long sRWXU;
    private static long sRUSR;
    private static long sWUSR;
    private static long sXUSR;
    private static long sRWXG;
    private static long sRGRP;
    private static long sWGRP;
    private static long sXGRP;
    private static long sRWXO;
    private static long sROTH;
    private static long sWOTH;
    private static long sXOTH;
    private static long sSUID;
    private static long sSGID;
    private static long sSVTX;
    private long mDev;
    private long mIno;
    private long mMode;
    private long mNLink;
    private long mUID;
    private long mGID;
    private long mRDev;
    private long mSize;
    private long mATime;
    private long mMTime;
    private long mCTime;
    private long mBlkSize;
    private long mBlocks;

    private static native void initMode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class clazz;
        if (Logger.isDebugEnabled(Stat.class)) {
            Logger.debug("Native start: initMode()", Stat.class);
        }
        try {
            Stat.initMode();
            Object var1 = null;
            clazz = Stat.class;
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            if (Logger.isDebugEnabled(Stat.class)) {
                Logger.debug("Native end: initMode()", Stat.class);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(clazz)) {
            Logger.debug("Native end: initMode()", Stat.class);
        }
    }

    private native void lstat(String var1) throws PosixException;

    private native boolean isBlk();

    private native boolean isChr();

    private native boolean isDir();

    private native boolean isFIFO();

    private native boolean isReg();

    private native boolean isLnk();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stat(String path) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: lstat('" + path + "')", this);
        }
        try {
            try {
                this.lstat(path);
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("lstat", path, ex);
                Object var4_3 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: lstat()", this);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: lstat()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: lstat()", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlockSpecial() {
        boolean bl;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: isBlk()", this);
        }
        try {
            bl = this.isBlk();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Native end: isBlk()", this);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native end: isBlk()", this);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCharacterSpecial() {
        boolean bl;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: isChr()", this);
        }
        try {
            bl = this.isChr();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Native end: isChr()", this);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native end: isChr()", this);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory() {
        boolean bl;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: isDir()", this);
        }
        try {
            bl = this.isDir();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Native end: isDir()", this);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native end: isDir()", this);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFIFOSpecial() {
        boolean bl;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: isFIFO()", this);
        }
        try {
            bl = this.isFIFO();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Native end: isFIFO()", this);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native end: isFIFO()", this);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegular() {
        boolean bl;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: isReg()", this);
        }
        try {
            bl = this.isReg();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Native end: isReg()", this);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native end: isReg()", this);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLink() {
        boolean bl;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: isLnk()", this);
        }
        try {
            bl = this.isLnk();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Native end: isLnk()", this);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native end: isLnk()", this);
        }
        return bl;
    }

    public long getDev() {
        return this.mDev;
    }

    public long getIno() {
        return this.mIno;
    }

    public long getMode() {
        return this.mMode;
    }

    public long getNLink() {
        return this.mNLink;
    }

    public long getUID() {
        return this.mUID;
    }

    public long getGID() {
        return this.mGID;
    }

    public long getRDev() {
        return this.mRDev;
    }

    public long getSize() {
        return this.mSize;
    }

    public long getATime() {
        return this.mATime;
    }

    public long getMTime() {
        return this.mMTime;
    }

    public long getCTime() {
        return this.mCTime;
    }

    public long getBlkSize() {
        return this.mBlkSize;
    }

    public long getBlocks() {
        return this.mBlocks;
    }

    static {
        PlatformUtil.assertPOSIX();
        NativeLoader.load();
        Stat.init();
        FMT = sFMT;
        RWXU = sRWXU;
        RUSR = sRUSR;
        WUSR = sWUSR;
        XUSR = sXUSR;
        RWXG = sRWXG;
        RGRP = sRGRP;
        WGRP = sWGRP;
        XGRP = sXGRP;
        RWXO = sRWXO;
        ROTH = sROTH;
        WOTH = sWOTH;
        XOTH = sXOTH;
        SUID = sSUID;
        SGID = sSGID;
        SVTX = sSVTX;
    }
}

