/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.posix;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.NativeLoader;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.HandlerWrapper;
import com.raplix.util.platform.posix.PackageInfo;
import com.raplix.util.platform.posix.PosixException;
import com.raplix.util.platform.posix.SignalHandler;
import java.util.HashSet;

public final class Signal {
    public static final long SIGHUP;
    public static final long SIGTERM;
    public static final long SIGINT;
    public static final long SIGQUIT;
    public static final long SIGABRT;
    public static final long SIGTSTP;
    public static final long SIGCONT;
    public static final long SIGCHLD;
    private static long sSIGHUP;
    private static long sSIGTERM;
    private static long sSIGINT;
    private static long sSIGQUIT;
    private static long sSIGABRT;
    private static long sSIGTSTP;
    private static long sSIGCONT;
    private static long sSIGCHLD;
    private static HashSet sHandled;

    private Signal() {
    }

    private static native void initSig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class clazz;
        if (Logger.isDebugEnabled(Signal.class)) {
            Logger.debug("Native start: initSig()", Signal.class);
        }
        try {
            Signal.initSig();
            Object var1 = null;
            clazz = Signal.class;
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            if (Logger.isDebugEnabled(Signal.class)) {
                Logger.debug("Native end: initSig()", Signal.class);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(clazz)) {
            Logger.debug("Native end: initSig()", Signal.class);
        }
    }

    private static native void kill(long var0, long var2) throws PosixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void send(long pID, long s) {
        Class clazz;
        block8: {
            block6: {
                if (Logger.isDebugEnabled(Signal.class)) {
                    Logger.debug("Native start: kill(" + pID + "," + s + ")", Signal.class);
                }
                try {
                    try {
                        Signal.kill(pID, s);
                    }
                    catch (PosixException ex) {
                        PackageInfo.throwCallFailed("kill", Long.toString(pID), Long.toString(s), ex);
                        Object var6_3 = null;
                        if (!Logger.isDebugEnabled(Signal.class)) return;
                        Logger.debug("Native end: kill()", Signal.class);
                        return;
                    }
                    Object var6_2 = null;
                    if (class$com$raplix$util$platform$posix$Signal != null) break block6;
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    if (!Logger.isDebugEnabled(Signal.class)) throw throwable;
                    Logger.debug("Native end: kill()", Signal.class);
                    throw throwable;
                }
                clazz = class$com$raplix$util$platform$posix$Signal = Signal.class$("com.raplix.util.platform.posix.Signal");
                break block8;
            }
            clazz = class$com$raplix$util$platform$posix$Signal;
        }
        if (!Logger.isDebugEnabled(clazz)) return;
        Logger.debug("Native end: kill()", Signal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(long s, SignalHandler h) {
        HashSet hashSet = sHandled;
        synchronized (hashSet) {
            Long sLong = new Long(s);
            if (sHandled.contains(sLong)) {
                PackageInfo.throwSignalHandled(s);
            }
            sHandled.add(sLong);
        }
        HandlerWrapper t = new HandlerWrapper(s, h);
        t.setDaemon(true);
        t.setPriority(10);
        t.start();
    }

    static {
        sHandled = new HashSet();
        PlatformUtil.assertPOSIX();
        NativeLoader.load();
        Signal.init();
        SIGHUP = sSIGHUP;
        SIGTERM = sSIGTERM;
        SIGINT = sSIGINT;
        SIGQUIT = sSIGQUIT;
        SIGABRT = sSIGABRT;
        SIGTSTP = sSIGTSTP;
        SIGCONT = sSIGCONT;
        SIGCHLD = sSIGCHLD;
    }
}

