/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.posix;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.NativeLoader;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.PackageInfo;
import com.raplix.util.platform.posix.PosixException;

public class Passwd {
    private String mName;
    private long mUID;
    private long mGID;
    private String mDir;
    private String mShell;

    private native void getpwuid_r(long var1) throws PosixException;

    private native void getpwnam_r(String var1) throws PosixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Passwd(long ID2) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: getpwuid_r(" + ID2 + ")", this);
        }
        try {
            try {
                this.getpwuid_r(ID2);
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("getpwuid_r", Long.toString(ID2), ex);
                Object var5_3 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: getpwuid_r()", this);
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: getpwuid_r()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: getpwuid_r()", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Passwd(String name) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: getpwnam_r('" + name + "')", this);
        }
        try {
            try {
                this.getpwnam_r(name);
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("getpwnam_r", name, ex);
                Object var4_3 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: getpwnam_r()", this);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: getpwnam_r()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: getpwnam_r()", this);
    }

    public String getName() {
        return this.mName;
    }

    public long getUID() {
        return this.mUID;
    }

    public long getGID() {
        return this.mGID;
    }

    public String getDir() {
        return this.mDir;
    }

    public String getShell() {
        return this.mShell;
    }

    static {
        PlatformUtil.assertPOSIX();
        NativeLoader.load();
    }
}

