/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.posix;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.posix.PackageInfo;
import com.raplix.util.platform.posix.PosixException;
import com.raplix.util.platform.posix.SignalHandler;
import com.raplix.util.threads.SafeThread;

class HandlerWrapper
extends SafeThread {
    private long mSignal;
    private SignalHandler mHandler;

    private void handle() {
        this.mHandler.handle(this.mSignal);
    }

    private native void register() throws PosixException;

    HandlerWrapper(long s, SignalHandler h) {
        this.mSignal = s;
        this.mHandler = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: register()", this);
        }
        try {
            try {
                this.register();
            }
            catch (PosixException ex) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(PackageInfo.createNoRegister(), ex, this);
                }
                Object var3_2 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: register()", this);
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: register()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: register()", this);
    }
}

