/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.posix;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.NativeLoader;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.PackageInfo;
import com.raplix.util.platform.posix.PosixException;

public class Group {
    private String mName;
    private long mGID;
    private String[] mMem;

    private native void getgrgid_r(long var1) throws PosixException;

    private native void getgrnam_r(String var1) throws PosixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group(long ID2) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: getgrgid_r(" + ID2 + ")", this);
        }
        try {
            try {
                this.getgrgid_r(ID2);
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("getgrgid_r", Long.toString(ID2), ex);
                Object var5_3 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: getgrgid_r()", this);
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: getgrgid_r()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: getgrgid_r()", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group(String name) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: getgrnam_r('" + name + "')", this);
        }
        try {
            try {
                this.getgrnam_r(name);
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("getgrnam_r", name, ex);
                Object var4_3 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: getgrnam_r()", this);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: getgrnam_r()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: getgrnam_r()", this);
    }

    public String getName() {
        return this.mName;
    }

    public long getGID() {
        return this.mGID;
    }

    public String[] getMem() {
        return this.mMem;
    }

    static {
        PlatformUtil.assertPOSIX();
        NativeLoader.load();
    }
}

