/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.posix;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.NativeLoader;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.PackageInfo;
import com.raplix.util.platform.posix.PosixException;

public class Dir {
    private String mPath;
    private long mHandle;

    private native void opendir() throws PosixException;

    private native void rewinddir() throws PosixException;

    private native long telldir() throws PosixException;

    private native void seekdir(long var1) throws PosixException;

    private native void readdir_r(DirEnt var1) throws PosixException;

    private native void closedir() throws PosixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Dir(String path) {
        this.mPath = path;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: opendir('" + this.mPath + "')", this);
        }
        try {
            try {
                this.opendir();
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("opendir", this.mPath, ex);
                Object var4_3 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: opendir()", this);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: opendir()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: opendir()", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rewind() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: rewinddir()", this);
        }
        try {
            try {
                this.rewinddir();
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("rewinddir", this.mPath, ex);
                Object var3_2 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: rewinddir()", this);
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: rewinddir()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: rewinddir()", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long tell() {
        long l;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: telldir()", this);
        }
        try {
            l = this.telldir();
            Object var4_3 = null;
        }
        catch (PosixException ex) {
            try {
                PackageInfo.throwCallFailed("telldir", this.mPath, ex);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (!Logger.isDebugEnabled(this)) throw throwable;
                Logger.debug("Native end: telldir()", this);
                throw throwable;
            }
            if (!Logger.isDebugEnabled(this)) return 0L;
            Logger.debug("Native end: telldir()", this);
            return 0L;
        }
        if (!Logger.isDebugEnabled(this)) return l;
        Logger.debug("Native end: telldir()", this);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void seek(long loc) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: seekdir(" + loc + ")", this);
        }
        try {
            try {
                this.seekdir(loc);
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("seekdir", this.mPath, ex);
                Object var5_3 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: seekdir()", this);
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: seekdir()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: seekdir()", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DirEnt read() {
        DirEnt dirEnt;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: readdir_r(<dirEnt>)", this);
        }
        try {
            DirEnt dirEnt2 = new DirEnt();
            this.readdir_r(dirEnt2);
            dirEnt = dirEnt2;
            Object var4_4 = null;
        }
        catch (PosixException ex) {
            try {
                PackageInfo.throwCallFailed("readdir_r", this.mPath, ex);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (!Logger.isDebugEnabled(this)) throw throwable;
                Logger.debug("Native end: readdir_r()", this);
                throw throwable;
            }
            if (!Logger.isDebugEnabled(this)) return null;
            Logger.debug("Native end: readdir_r()", this);
            return null;
        }
        if (!Logger.isDebugEnabled(this)) return dirEnt;
        Logger.debug("Native end: readdir_r()", this);
        return dirEnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: closedir()", this);
        }
        try {
            try {
                this.closedir();
            }
            catch (PosixException ex) {
                PackageInfo.throwCallFailed("closedir", this.mPath, ex);
                Object var3_2 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: closedir()", this);
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: closedir()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: closedir()", this);
    }

    static {
        PlatformUtil.assertPOSIX();
        NativeLoader.load();
    }

    public static class DirEnt {
        private boolean mValid;
        private long mIno;
        private String mName;

        public boolean isValid() {
            return this.mValid;
        }

        public long getIno() {
            return this.mIno;
        }

        public String getName() {
            return this.mName;
        }
    }
}

