/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.linux;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.NativeLoader;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.linux.LinuxException;
import com.raplix.util.platform.linux.PackageInfo;

public class StatVFS {
    public static final long RDONLY;
    public static final long NOSUID;
    private static long sRDONLY;
    private static long sNOSUID;
    private long mBSize;
    private long mFrSize;
    private long mBlocks;
    private long mBFree;
    private long mBAvail;
    private long mFiles;
    private long mFFree;
    private long mFAvail;
    private long mFSID;
    private long mFlag;
    private long mNameMax;

    private static native void initFlags();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class clazz;
        if (Logger.isDebugEnabled(StatVFS.class)) {
            Logger.debug("Native start: initFlags()", StatVFS.class);
        }
        try {
            StatVFS.initFlags();
            Object var1 = null;
            clazz = StatVFS.class;
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            if (Logger.isDebugEnabled(StatVFS.class)) {
                Logger.debug("Native end: initFlags()", StatVFS.class);
            }
            throw throwable;
        }
        if (Logger.isDebugEnabled(clazz)) {
            Logger.debug("Native end: initFlags()", StatVFS.class);
        }
    }

    private native void statvfs(String var1) throws LinuxException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StatVFS(String path) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Native start: statvfs('" + path + "')", this);
        }
        try {
            try {
                this.statvfs(path);
            }
            catch (LinuxException ex) {
                PackageInfo.throwCallFailed("statvfs", path, ex);
                Object var4_3 = null;
                if (!Logger.isDebugEnabled(this)) return;
                Logger.debug("Native end: statvfs()", this);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Logger.isDebugEnabled(this)) throw throwable;
            Logger.debug("Native end: statvfs()", this);
            throw throwable;
        }
        if (!Logger.isDebugEnabled(this)) return;
        Logger.debug("Native end: statvfs()", this);
    }

    public long getBSize() {
        return this.mBSize;
    }

    public long getFrSize() {
        return this.mFrSize;
    }

    public long getBlocks() {
        return this.mBlocks;
    }

    public long getBFree() {
        return this.mBFree;
    }

    public long getBAvail() {
        return this.mBAvail;
    }

    public long getFiles() {
        return this.mFiles;
    }

    public long getFFree() {
        return this.mFFree;
    }

    public long getFAvail() {
        return this.mFAvail;
    }

    public long getFSID() {
        return this.mFSID;
    }

    public long getFlag() {
        return this.mFlag;
    }

    public long getNameMax() {
        return this.mNameMax;
    }

    static {
        PlatformUtil.assertLinux();
        NativeLoader.load();
        StatVFS.init();
        RDONLY = sRDONLY;
        NOSUID = sNOSUID;
    }
}

