/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.common;

import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PackageInfo;
import com.raplix.util.platform.common.Platform;
import java.io.File;

public final class PlatformUtil {
    public static final String OS_NAME = Platform.LOCAL.getName();
    public static final boolean CYGWIN = Platform.LOCAL.getCygwin();
    private static final String LIBRARY_DIR = System.getProperty("rox_home_dir") + File.separator + ".." + File.separator + "common" + File.separator + "lib";
    public static final String SUB_DIR_WINDOWS = "win32";
    private static final String LIBRARY_DIR_WINDOWS = LIBRARY_DIR + File.separator + "win32";
    private static final String LIBRARY_PREFIX_WINDOWS = LIBRARY_DIR_WINDOWS + File.separator;
    private static final String LIBRARY_SUFFIX_WINDOWS = ".dll";
    private static final String SUB_DIR_CYGWIN = "cygwin";
    private static final String LIBRARY_DIR_CYGWIN = LIBRARY_DIR + File.separator + "cygwin";
    private static final String LIBRARY_PREFIX_CYGWIN = LIBRARY_DIR_CYGWIN + File.separator;
    private static final String LIBRARY_SUFFIX_CYGWIN = ".dll";
    private static final String SUB_DIR_LINUX = "linux";
    private static final String LIBRARY_DIR_LINUX = LIBRARY_DIR + File.separator + "linux";
    private static final String LIBRARY_PREFIX_LINUX = LIBRARY_DIR_LINUX + File.separator + "lib";
    private static final String LIBRARY_SUFFIX_LINUX = ".so";
    private static final String SUB_DIR_SOLARIS = "solaris";
    private static final String LIBRARY_DIR_SOLARIS = LIBRARY_DIR + File.separator + "solaris";
    private static final String LIBRARY_PREFIX_SOLARIS = LIBRARY_DIR_SOLARIS + File.separator + "lib";
    private static final String LIBRARY_SUFFIX_SOLARIS = ".so";
    private static final String SUB_DIR_AIX = "aix";
    private static final String LIBRARY_DIR_AIX = LIBRARY_DIR + File.separator + "aix";
    private static final String LIBRARY_PREFIX_AIX = LIBRARY_DIR_AIX + File.separator + "lib";
    private static final String LIBRARY_SUFFIX_AIX = ".so";
    private static final String SUB_DIR_HPUX = "hpux";
    private static final String LIBRARY_DIR_HPUX = LIBRARY_DIR + File.separator + "hpux";
    private static final String LIBRARY_PREFIX_HPUX = LIBRARY_DIR_HPUX + File.separator + "lib";
    private static final String LIBRARY_SUFFIX_HPUX = ".sl";
    private static PathProcessor sPathProcessor;

    private PlatformUtil() {
    }

    public static String getNativeSubDir() {
        if (PlatformUtil.isSolaris()) {
            return SUB_DIR_SOLARIS;
        }
        if (PlatformUtil.isLinux()) {
            return SUB_DIR_LINUX;
        }
        if (PlatformUtil.isAix()) {
            return SUB_DIR_AIX;
        }
        if (PlatformUtil.isHpux()) {
            return SUB_DIR_HPUX;
        }
        if (PlatformUtil.isCygwin()) {
            return SUB_DIR_CYGWIN;
        }
        if (PlatformUtil.isWin32()) {
            return SUB_DIR_WINDOWS;
        }
        return ".";
    }

    public static String getLibraryPath(String name) {
        StringBuffer buffer = new StringBuffer();
        if (PlatformUtil.isSolaris()) {
            buffer.append(LIBRARY_PREFIX_SOLARIS);
        } else if (PlatformUtil.isLinux()) {
            buffer.append(LIBRARY_PREFIX_LINUX);
        } else if (PlatformUtil.isAix()) {
            buffer.append(LIBRARY_PREFIX_AIX);
        } else if (PlatformUtil.isHpux()) {
            buffer.append(LIBRARY_PREFIX_HPUX);
        } else if (PlatformUtil.isCygwin()) {
            buffer.append(LIBRARY_PREFIX_CYGWIN);
        } else if (PlatformUtil.isWin32()) {
            buffer.append(LIBRARY_PREFIX_WINDOWS);
        }
        buffer.append(name);
        String suffix = PlatformUtil.getLibrarySuffix();
        if (suffix != null) {
            buffer.append(suffix);
        }
        String libPath = new File(buffer.toString()).getAbsolutePath();
        return sPathProcessor == null ? libPath : sPathProcessor.getLibraryPath(libPath, PlatformUtil.getNativeSubDir());
    }

    public static String getPlatformLibraryPathIndentifier() {
        if (PlatformUtil.isSolaris()) {
            return "LD_LIBRARY_PATH";
        }
        if (PlatformUtil.isLinux()) {
            return "LD_LIBRARY_PATH";
        }
        if (PlatformUtil.isAix()) {
            return "LD_LIBRARY_PATH";
        }
        if (PlatformUtil.isHpux()) {
            return "SHLIB_PATH";
        }
        if (PlatformUtil.isCygwin()) {
            return "LD_LIBRARY_PATH";
        }
        if (PlatformUtil.isWin32()) {
            return "";
        }
        return null;
    }

    public static String getLibraryPrefix() {
        if (PlatformUtil.isSolaris()) {
            return "lib";
        }
        if (PlatformUtil.isLinux()) {
            return "lib";
        }
        if (PlatformUtil.isAix()) {
            return "lib";
        }
        if (PlatformUtil.isHpux()) {
            return "lib";
        }
        if (PlatformUtil.isCygwin()) {
            return "";
        }
        if (PlatformUtil.isWin32()) {
            return "";
        }
        return null;
    }

    public static String getLibrarySuffix() {
        if (PlatformUtil.isSolaris()) {
            return ".so";
        }
        if (PlatformUtil.isLinux()) {
            return ".so";
        }
        if (PlatformUtil.isAix()) {
            return ".so";
        }
        if (PlatformUtil.isHpux()) {
            return LIBRARY_SUFFIX_HPUX;
        }
        if (PlatformUtil.isCygwin()) {
            return ".dll";
        }
        if (PlatformUtil.isWin32()) {
            return ".dll";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadLibrary(String name) {
        Class clazz;
        block8: {
            block6: {
                String path = PlatformUtil.getLibraryPath(name);
                if (Logger.isDebugEnabled(PlatformUtil.class)) {
                    Logger.debug("Native start: load from '" + path + "'", PlatformUtil.class);
                }
                try {
                    try {
                        System.load(path);
                    }
                    catch (UnsatisfiedLinkError ex) {
                        PackageInfo.throwLibraryNotFound(path, ex);
                        Object var4_3 = null;
                        if (!Logger.isDebugEnabled(PlatformUtil.class)) return;
                        Logger.debug("Native end: load", PlatformUtil.class);
                        return;
                    }
                    Object var4_2 = null;
                    if (class$com$raplix$util$platform$common$PlatformUtil != null) break block6;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!Logger.isDebugEnabled(PlatformUtil.class)) throw throwable;
                    Logger.debug("Native end: load", PlatformUtil.class);
                    throw throwable;
                }
                clazz = class$com$raplix$util$platform$common$PlatformUtil = PlatformUtil.class$("com.raplix.util.platform.common.PlatformUtil");
                break block8;
            }
            clazz = class$com$raplix$util$platform$common$PlatformUtil;
        }
        if (!Logger.isDebugEnabled(clazz)) return;
        Logger.debug("Native end: load", PlatformUtil.class);
    }

    public static boolean isWin2k() {
        return Platform.LOCAL.isWin2k();
    }

    public static void assertWin2k() {
        Platform.LOCAL.assertWin2k();
    }

    public static boolean isWin2k3() {
        return Platform.LOCAL.isWin2k3();
    }

    public static void assertWin2k3() {
        Platform.LOCAL.assertWin2k3();
    }

    public static boolean isWinXP() {
        return Platform.LOCAL.isWinXP();
    }

    public static void assertWinXP() {
        Platform.LOCAL.assertWinXP();
    }

    public static boolean isWin32() {
        return Platform.LOCAL.isWin32();
    }

    public static void assertWin32() {
        Platform.LOCAL.assertWin32();
    }

    public static boolean isCygwin() {
        return Platform.LOCAL.isCygwin();
    }

    public static void assertCygwin() {
        Platform.LOCAL.assertCygwin();
    }

    public static boolean isPureWin32() {
        return Platform.LOCAL.isPureWin32();
    }

    public static void assertPureWin32() {
        Platform.LOCAL.assertPureWin32();
    }

    public static boolean isLinux() {
        return Platform.LOCAL.isLinux();
    }

    public static void assertLinux() {
        Platform.LOCAL.assertLinux();
    }

    public static boolean isLinuxEnigma() {
        return Platform.LOCAL.isLinuxEnigma();
    }

    public static void assertLinuxEnigma() {
        Platform.LOCAL.assertLinuxEnigma();
    }

    public static boolean isLinuxValhalla() {
        return Platform.LOCAL.isLinuxValhalla();
    }

    public static void assertLinuxValhalla() {
        Platform.LOCAL.assertLinuxValhalla();
    }

    public static boolean isLinuxPsyche() {
        return Platform.LOCAL.isLinuxPsyche();
    }

    public static void assertLinuxPsyche() {
        Platform.LOCAL.assertLinuxPsyche();
    }

    public static boolean isLinuxPensacola() {
        return Platform.LOCAL.isLinuxPensacola();
    }

    public static void assertLinuxPensacola() {
        Platform.LOCAL.assertLinuxPensacola();
    }

    public static boolean isLinuxTaroon() {
        return Platform.LOCAL.isLinuxTaroon();
    }

    public static void assertLinuxTaroon() {
        Platform.LOCAL.assertLinuxTaroon();
    }

    public static boolean isLinuxNahant() {
        return Platform.LOCAL.isLinuxNahant();
    }

    public static void assertLinuxNahant() {
        Platform.LOCAL.assertLinuxNahant();
    }

    public static boolean isLinuxRedHat() {
        return Platform.LOCAL.isLinuxRedHat();
    }

    public static void assertLinuxRedHat() {
        Platform.LOCAL.assertLinuxSles();
    }

    public static boolean isLinuxSles() {
        return Platform.LOCAL.isLinuxSles();
    }

    public static void assertLinuxSles() {
        Platform.LOCAL.assertLinuxSles();
    }

    public static boolean isLinuxSles8() {
        return Platform.LOCAL.isLinuxSles8();
    }

    public static void assertLinuxSles8() {
        Platform.LOCAL.assertLinuxSles8();
    }

    public static boolean isLinuxSles9() {
        return Platform.LOCAL.isLinuxSles9();
    }

    public static void assertLinuxSles9() {
        Platform.LOCAL.assertLinuxSles9();
    }

    public static boolean isSolaris() {
        return Platform.LOCAL.isSolaris();
    }

    public static void assertSolaris() {
        Platform.LOCAL.assertSolaris();
    }

    public static boolean isSolarisX86() {
        return Platform.LOCAL.isSolarisX86();
    }

    public static void assertSolarisX86() {
        Platform.LOCAL.assertSolarisX86();
    }

    public static boolean isSolarisSparc() {
        return Platform.LOCAL.isSolarisSparc();
    }

    public static void assertSolarisSparc() {
        Platform.LOCAL.assertSolarisSparc();
    }

    public static boolean isLinux32() {
        return Platform.LOCAL.isLinux32();
    }

    public static void assertLinux32() {
        Platform.LOCAL.assertLinux32();
    }

    public static boolean isLinux64() {
        return Platform.LOCAL.isLinux64();
    }

    public static void assertLinux64() {
        Platform.LOCAL.assertLinux64();
    }

    public static boolean isAix() {
        return Platform.LOCAL.isAix();
    }

    public static void assertAix() {
        Platform.LOCAL.assertAix();
    }

    public static boolean isHpux() {
        return Platform.LOCAL.isHpux();
    }

    public static void assertHpux() {
        Platform.LOCAL.assertHpux();
    }

    public static boolean isUnix() {
        return Platform.LOCAL.isUnix();
    }

    public static void assertUnix() {
        Platform.LOCAL.assertUnix();
    }

    public static boolean isPOSIX() {
        return Platform.LOCAL.isPOSIX();
    }

    public static void assertPOSIX() {
        Platform.LOCAL.assertPOSIX();
    }

    public static void registerPathProcessor(PathProcessor processor) {
        sPathProcessor = processor;
    }

    public static interface PathProcessor {
        public String getLibraryPath(String var1, String var2);
    }
}

