/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.platform.common;

import com.raplix.util.enum.Enum;
import com.raplix.util.enum.EnumFactory;
import com.raplix.util.enum.NoSuchEnumException;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PackageInfo;
import java.io.IOException;

public class Platform {
    public static final String OS_NAME_W2K3 = "Windows 2003";
    public static final String OS_NAME_W2K = "Windows 2000";
    public static final String OS_NAME_WXP = "Windows XP";
    public static final String OS_NAME_LINUX = "Linux";
    public static final String CUSTOM_NAME_REDHAT_LINUX = "Red Hat Linux";
    public static final String OS_NAME_SOLARIS = "SunOS";
    public static final String OS_NAME_HPUX = "HP-UX";
    public static final String OS_NAME_AIX = "AIX";
    public static final String CUSTOM_NAME_CYGWIN_PREFIX = "Cygwin - ";
    public static final String OS_LINUX_ENIGMA = "Red Hat Linux release 7.2";
    public static final String OS_LINUX_VALHALLA = "Red Hat Linux release 7.3";
    public static final String OS_LINUX_PSYCHE = "Red Hat Linux release 8.0";
    public static final String OS_LINUX_PENSACOLA = "Red Hat Linux Advanced Server release 2.1AS";
    public static final String OS_LINUX_TAROON = "Red Hat Enterprise Linux AS release 3";
    public static final String OS_LINUX_NAHANT = "Red Hat Enterprise Linux AS release 4";
    public static final String CUSTOM_VERSION_LINUX_ENIGMA = "7.2";
    public static final String CUSTOM_VERSION_LINUX_VALHALLA = "7.3";
    public static final String CUSTOM_VERSION_LINUX_PSYCHE = "8.0";
    public static final String CUSTOM_VERSION_LINUX_PENSACOLA = "2.1AS";
    public static final String CUSTOM_VERSION_LINUX_TAROON = "3.0AS";
    public static final String CUSTOM_VERSION_LINUX_NAHANT = "4.0AS";
    public static final String OS_LINUX_SLES8 = "SuSE SLES-8";
    public static final String OS_LINUX_SLES9 = "SUSE LINUX Enterprise Server 9";
    public static final String CUSTOM_NAME_SUSE_LINUX = "SuSE Linux";
    public static final String CUSTOM_VERSION_SUSE_LINUX_8 = "8";
    public static final String CUSTOM_VERSION_SUSE_LINUX_9 = "9";
    public static final String CYGWIN = "cygwin";
    public static final String NAME_WIN32 = "win32";
    public static final String NAME_CYGWIN = "cygwin";
    public static final String NAME_PURE_WIN32 = "msWin32";
    public static final String NAME_POSIX = "posix";
    public static final String NAME_UNIX = "unix";
    public static final String OS_ARCH_I386 = "i386";
    public static final String OS_ARCH_AMD64 = "amd64";
    public static final String OS_ARCH_X86 = "x86";
    public static final String OS_ARCH_SPARC = "sparc";
    public static final String OS_ARCH_PPC = "ppc";
    public static final String OS_ARCH_PARISC = "PA-RISC2.0";
    public static final Platform LOCAL;
    private static final String REDHAT_RELEASE_FILENAME = "/etc/redhat-release";
    private static final String SUSE_RELEASE_FILENAME = "/etc/SuSE-release";
    private String mName;
    private String mOSName;
    private String mOSVersion;
    private String mOSArch;
    private boolean mCygwin;

    public Platform(String name, String version, String arch, String linuxRelease, boolean cygwin, LinuxPlatform platform) {
        this.mName = name;
        this.mCygwin = cygwin;
        this.mOSName = name;
        this.mOSVersion = version;
        this.mOSArch = arch;
        if (this.isLinux() && linuxRelease != null && platform != null) {
            if (platform.equals(LinuxPlatform.REDHAT)) {
                this.mOSName = CUSTOM_NAME_REDHAT_LINUX;
                if (linuxRelease.startsWith(OS_LINUX_ENIGMA)) {
                    this.mOSVersion = CUSTOM_VERSION_LINUX_ENIGMA;
                } else if (linuxRelease.startsWith(OS_LINUX_VALHALLA)) {
                    this.mOSVersion = CUSTOM_VERSION_LINUX_VALHALLA;
                } else if (linuxRelease.startsWith(OS_LINUX_PSYCHE)) {
                    this.mOSVersion = CUSTOM_VERSION_LINUX_PSYCHE;
                } else if (linuxRelease.startsWith(OS_LINUX_PENSACOLA)) {
                    this.mOSVersion = CUSTOM_VERSION_LINUX_PENSACOLA;
                } else if (linuxRelease.startsWith(OS_LINUX_TAROON)) {
                    this.mOSVersion = CUSTOM_VERSION_LINUX_TAROON;
                } else if (linuxRelease.startsWith(OS_LINUX_NAHANT)) {
                    this.mOSVersion = CUSTOM_VERSION_LINUX_NAHANT;
                } else if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Platform is an unsupported red hat linux version", this);
                }
            } else if (platform.equals(LinuxPlatform.SUSE)) {
                this.mOSName = CUSTOM_NAME_SUSE_LINUX;
                this.mOSVersion = linuxRelease.startsWith(OS_LINUX_SLES8) ? CUSTOM_VERSION_SUSE_LINUX_8 : (linuxRelease.startsWith(OS_LINUX_SLES9) ? CUSTOM_VERSION_SUSE_LINUX_9 : this.parseSuseVersion(linuxRelease));
            } else if (Logger.isDebugEnabled(this)) {
                Logger.debug("Platform is an unsupported linux distribution", this);
            }
        }
        if (cygwin) {
            this.mOSName = CUSTOM_NAME_CYGWIN_PREFIX + this.mOSName;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Platform is " + this.mName + "(" + this.mOSName + "," + this.mOSVersion + ") on " + this.mOSArch, this);
        }
    }

    public Platform(String osName, String osVersion, String osArch) {
        this.mOSName = osName;
        this.mOSVersion = osVersion;
        this.mOSArch = osArch;
        if (osName.startsWith(CUSTOM_NAME_CYGWIN_PREFIX)) {
            this.mCygwin = true;
            this.mName = osName.substring(CUSTOM_NAME_CYGWIN_PREFIX.length());
        } else {
            this.mCygwin = false;
            this.mName = osName;
        }
        if (this.mName.equals(CUSTOM_NAME_REDHAT_LINUX) || this.mName.equals(CUSTOM_NAME_SUSE_LINUX)) {
            this.mName = OS_NAME_LINUX;
        }
    }

    private String parseSuseVersion(String linuxRelease) {
        String suseVersionIndicator = "VERSION = ";
        return linuxRelease.substring(linuxRelease.lastIndexOf(suseVersionIndicator) + suseVersionIndicator.length(), linuxRelease.length()).trim();
    }

    private boolean isRedHatVersion(String version) {
        return CUSTOM_NAME_REDHAT_LINUX.equals(this.getOSName()) && (version == null || version.equals(this.getOSVersion()));
    }

    public String getName() {
        return this.mName;
    }

    public boolean getCygwin() {
        return this.mCygwin;
    }

    public boolean isWin2k3() {
        return OS_NAME_W2K3.equals(this.getName());
    }

    public void assertWin2k3() {
        if (!this.isWin2k3()) {
            PackageInfo.throwPlatformMismatch(OS_NAME_W2K3, this.toString());
        }
    }

    public boolean isWin2k() {
        return OS_NAME_W2K.equals(this.getName());
    }

    public void assertWin2k() {
        if (!this.isWin2k()) {
            PackageInfo.throwPlatformMismatch(OS_NAME_W2K, this.toString());
        }
    }

    public boolean isWinXP() {
        return OS_NAME_WXP.equals(this.getName());
    }

    public void assertWinXP() {
        if (!this.isWinXP()) {
            PackageInfo.throwPlatformMismatch(OS_NAME_WXP, this.toString());
        }
    }

    public boolean isWin32() {
        return this.isWin2k() || this.isWinXP() || this.isWin2k3();
    }

    public void assertWin32() {
        if (!this.isWin32()) {
            PackageInfo.throwPlatformMismatch(NAME_WIN32, this.toString());
        }
    }

    public boolean isCygwin() {
        return this.isWin32() && this.getCygwin();
    }

    public void assertCygwin() {
        if (!this.isCygwin()) {
            PackageInfo.throwPlatformMismatch("cygwin", this.toString());
        }
    }

    public boolean isPureWin32() {
        return this.isWin32() && !this.getCygwin();
    }

    public void assertPureWin32() {
        if (!this.isPureWin32()) {
            PackageInfo.throwPlatformMismatch(NAME_PURE_WIN32, this.toString());
        }
    }

    public boolean isLinux() {
        return OS_NAME_LINUX.equals(this.getName());
    }

    public void assertLinux() {
        if (!this.isLinux()) {
            PackageInfo.throwPlatformMismatch(OS_NAME_LINUX, this.toString());
        }
    }

    public boolean isLinuxEnigma() {
        return this.isRedHatVersion(CUSTOM_VERSION_LINUX_ENIGMA);
    }

    public void assertLinuxEnigma() {
        if (!this.isLinuxEnigma()) {
            PackageInfo.throwPlatformMismatch(OS_LINUX_ENIGMA, this.toString());
        }
    }

    public boolean isLinuxValhalla() {
        return this.isRedHatVersion(CUSTOM_VERSION_LINUX_VALHALLA);
    }

    public void assertLinuxValhalla() {
        if (!this.isLinuxValhalla()) {
            PackageInfo.throwPlatformMismatch(OS_LINUX_VALHALLA, this.toString());
        }
    }

    public boolean isLinuxPsyche() {
        return this.isRedHatVersion(CUSTOM_VERSION_LINUX_PSYCHE);
    }

    public void assertLinuxPsyche() {
        if (!this.isLinuxPsyche()) {
            PackageInfo.throwPlatformMismatch(OS_LINUX_PSYCHE, this.toString());
        }
    }

    public boolean isLinuxPensacola() {
        return this.isRedHatVersion(CUSTOM_VERSION_LINUX_PENSACOLA);
    }

    public void assertLinuxPensacola() {
        if (!this.isLinuxPensacola()) {
            PackageInfo.throwPlatformMismatch(OS_LINUX_PENSACOLA, this.toString());
        }
    }

    public boolean isLinuxTaroon() {
        return this.isRedHatVersion(CUSTOM_VERSION_LINUX_TAROON);
    }

    public void assertLinuxTaroon() {
        if (!this.isLinuxTaroon()) {
            PackageInfo.throwPlatformMismatch(OS_LINUX_TAROON, this.toString());
        }
    }

    public boolean isLinuxNahant() {
        return this.isRedHatVersion(CUSTOM_VERSION_LINUX_NAHANT);
    }

    public void assertLinuxNahant() {
        if (!this.isLinuxNahant()) {
            PackageInfo.throwPlatformMismatch(OS_LINUX_NAHANT, this.toString());
        }
    }

    public boolean isLinuxSles() {
        return CUSTOM_NAME_SUSE_LINUX.equals(this.getOSName());
    }

    public void assertLinuxSles() {
        if (!this.isLinuxSles()) {
            PackageInfo.throwPlatformMismatch(CUSTOM_NAME_SUSE_LINUX, this.toString());
        }
    }

    public boolean isSolaris() {
        return OS_NAME_SOLARIS.equals(this.getName());
    }

    public void assertSolaris() {
        if (!this.isSolaris()) {
            PackageInfo.throwPlatformMismatch(OS_NAME_SOLARIS, this.toString());
        }
    }

    public boolean isLinuxRedHat() {
        return this.isRedHatVersion(null);
    }

    public void assertLinuxRedHat() {
        if (!this.isLinuxRedHat()) {
            PackageInfo.throwPlatformMismatch(CUSTOM_NAME_REDHAT_LINUX, this.toString());
        }
    }

    public boolean isLinuxSles8() {
        return this.isLinuxSles() && this.getOSVersion().equals(CUSTOM_VERSION_SUSE_LINUX_8);
    }

    public void assertLinuxSles8() {
        if (!this.isLinuxSles8()) {
            PackageInfo.throwPlatformMismatch(CUSTOM_NAME_SUSE_LINUX, this.toString());
        }
    }

    public boolean isLinuxSles9() {
        return this.isLinuxSles() && this.getOSVersion().equals(CUSTOM_VERSION_SUSE_LINUX_9);
    }

    public void assertLinuxSles9() {
        if (!this.isLinuxSles9()) {
            PackageInfo.throwPlatformMismatch(CUSTOM_NAME_SUSE_LINUX, this.toString());
        }
    }

    public boolean isHpux() {
        return OS_NAME_HPUX.equals(this.getName());
    }

    public void assertHpux() {
        if (!this.isHpux()) {
            PackageInfo.throwPlatformMismatch(OS_NAME_HPUX, this.toString());
        }
    }

    public boolean isAix() {
        return OS_NAME_AIX.equals(this.getName());
    }

    public void assertAix() {
        if (!this.isAix()) {
            PackageInfo.throwPlatformMismatch(OS_NAME_AIX, this.toString());
        }
    }

    public boolean isUnix() {
        return this.isLinux() || this.isSolaris() || this.isAix() || this.isHpux();
    }

    public void assertUnix() {
        if (!this.isUnix()) {
            PackageInfo.throwPlatformMismatch(NAME_UNIX, this.toString());
        }
    }

    public boolean isPOSIX() {
        return this.isCygwin() || this.isUnix();
    }

    public void assertPOSIX() {
        if (!this.isPOSIX()) {
            PackageInfo.throwPlatformMismatch(NAME_POSIX, this.toString());
        }
    }

    public boolean isSparc() {
        return OS_ARCH_SPARC.equals(this.getOSArch());
    }

    public void assertSparc() {
        if (!this.isSparc()) {
            PackageInfo.throwPlatformMismatch(OS_ARCH_SPARC, this.toString());
        }
    }

    public boolean isSolarisX86() {
        return this.isX86() && this.isSolaris();
    }

    public void assertSolarisX86() {
        if (!this.isSolarisX86()) {
            PackageInfo.throwPlatformMismatch("SunOS x86", this.toString());
        }
    }

    public boolean isSolarisSparc() {
        return this.isSparc() && this.isSolaris();
    }

    public void assertSolarisSparc() {
        if (!this.isSolarisSparc()) {
            PackageInfo.throwPlatformMismatch("SunOS sparc", this.toString());
        }
    }

    public boolean isX86() {
        return OS_ARCH_X86.equals(this.getOSArch());
    }

    public void assertX86() {
        if (!this.isX86()) {
            PackageInfo.throwPlatformMismatch(OS_ARCH_X86, this.toString());
        }
    }

    public boolean isI386() {
        return OS_ARCH_I386.equals(this.getOSArch());
    }

    public void assertI386() {
        if (!this.isI386()) {
            PackageInfo.throwPlatformMismatch(OS_ARCH_I386, this.toString());
        }
    }

    public boolean isLinux32() {
        return this.isLinux() && this.isI386();
    }

    public void assertLinux32() {
        if (!this.isLinux32()) {
            PackageInfo.throwPlatformMismatch(OS_ARCH_I386, this.toString());
        }
    }

    public boolean isLinux64() {
        return this.isLinux() && this.isX86_64();
    }

    public void assertLinux64() {
        if (!this.isLinux64()) {
            PackageInfo.throwPlatformMismatch(OS_ARCH_AMD64, this.toString());
        }
    }

    public boolean isX86_64() {
        return OS_ARCH_AMD64.equals(this.getOSArch());
    }

    public void assertX86_64() {
        if (!this.isX86_64()) {
            PackageInfo.throwPlatformMismatch(OS_ARCH_AMD64, this.toString());
        }
    }

    public boolean isPPC() {
        return OS_ARCH_PPC.equals(this.getOSArch());
    }

    public void assertPPC() {
        if (!this.isPPC()) {
            PackageInfo.throwPlatformMismatch(OS_ARCH_PPC, this.toString());
        }
    }

    public boolean isPARISC() {
        return OS_ARCH_PARISC.equals(this.getOSArch());
    }

    public void assertPARISC() {
        if (!this.isPARISC()) {
            PackageInfo.throwPlatformMismatch(OS_ARCH_PARISC, this.toString());
        }
    }

    public String getOSName() {
        return this.mOSName;
    }

    public String getOSVersion() {
        return this.mOSVersion;
    }

    public String getOSArch() {
        return this.mOSArch;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(',');
        buffer.append(this.getOSName());
        buffer.append(',');
        buffer.append(this.getOSVersion());
        buffer.append(',').append(this.getOSArch());
        if (this.isWin32()) {
            buffer.append(',');
            buffer.append(NAME_WIN32);
        }
        if (this.isPureWin32()) {
            buffer.append(',');
            buffer.append(NAME_PURE_WIN32);
        }
        if (this.isCygwin()) {
            buffer.append(',');
            buffer.append("cygwin");
        }
        if (this.isPOSIX()) {
            buffer.append(',');
            buffer.append(NAME_POSIX);
        }
        if (this.isUnix()) {
            buffer.append(',');
            buffer.append(NAME_UNIX);
        }
        return buffer.toString();
    }

    static {
        String linuxRelease = null;
        LinuxPlatform platform = LinuxPlatform.UNKNOWN;
        try {
            linuxRelease = new String(CopyUtil.readText(REDHAT_RELEASE_FILENAME));
            linuxRelease = linuxRelease.replace('\n', ' ');
            platform = LinuxPlatform.REDHAT;
        }
        catch (IOException e) {
            try {
                linuxRelease = new String(CopyUtil.readText(SUSE_RELEASE_FILENAME));
                linuxRelease = linuxRelease.replace('\n', ' ');
                platform = LinuxPlatform.SUSE;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOCAL = new Platform(System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), linuxRelease, Boolean.getBoolean("cygwin"), platform);
    }

    public static class LinuxPlatform
    extends Enum {
        public static final Factory FACTORY = new Factory();
        public static final LinuxPlatform REDHAT = new LinuxPlatform("redhat");
        public static final LinuxPlatform SUSE = new LinuxPlatform("suse");
        public static final LinuxPlatform UNKNOWN = new LinuxPlatform("unknown");

        private LinuxPlatform(String stringValue) {
            super(stringValue, FACTORY);
        }

        public static class Factory
        extends EnumFactory {
            private static final LinuxPlatform[] EMPTY_ARR = new LinuxPlatform[0];

            private Factory() {
                super(3);
            }

            public LinuxPlatform get(String value) throws NoSuchEnumException {
                return (LinuxPlatform)this.getEnum(value);
            }

            public LinuxPlatform get(int value) throws NoSuchEnumException {
                return (LinuxPlatform)this.getEnum(value);
            }

            public LinuxPlatform[] getAll() {
                return (LinuxPlatform[])this.getAllEnums(EMPTY_ARR);
            }
        }
    }
}

