/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.minidb;

import com.raplix.util.iowrappers.AtomicOutput;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.WriterWrapper;
import com.raplix.util.minidb.PackageInfo;
import com.raplix.util.minidb.ReadOnlyTable;
import com.raplix.util.string.CSVUtil;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class WritableTable
extends ReadOnlyTable {
    private boolean mDirty = false;

    public WritableTable(String file, int columnCount, int keyIndex) {
        super(file, columnCount, keyIndex);
    }

    public WritableTable(String file, int columnCount) {
        super(file, columnCount);
    }

    private void assertColumnCount(int actual) {
        if (actual != this.getColumnCount()) {
            throw PackageInfo.createBadColumnCount(this.getColumnCount(), actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String[] row) {
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            this.mTable.put(row[this.getKeyIndex()], row);
            this.mDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String[] row) throws IOException {
        this.assertColumnCount(row.length);
        this.load();
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            String key = row[this.getKeyIndex()];
            if (this.mTable.get(key) != null) {
                throw PackageInfo.createKeyExists(key);
            }
            this.put(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String[] row) throws IOException {
        this.assertColumnCount(row.length);
        this.load();
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            String key = row[this.getKeyIndex()];
            if (this.mTable.get(key) == null) {
                throw PackageInfo.createKeyNotExist(key);
            }
            this.put(row);
        }
    }

    public void insertOrUpdate(String[] row) throws IOException {
        this.assertColumnCount(row.length);
        this.load();
        this.put(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        this.load();
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            if (this.mTable.size() > 0) {
                this.mTable.clear();
                this.mDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String key) throws IOException {
        this.load();
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            if (this.mTable.get(key) == null) {
                throw PackageInfo.createKeyNotExist(key);
            }
            this.mTable.remove(key);
            this.mDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDelete(String key) throws IOException {
        this.load();
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            if (this.mTable.remove(key) != null) {
                this.mDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (!this.mDirty) {
            return;
        }
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            if (!this.mDirty) {
                return;
            }
            Closer c = new Closer();
            try {
                AtomicOutput wrapper = new AtomicOutput(new File(this.getFile()));
                c.register(wrapper);
                WriterWrapper rawWriter = new WriterWrapper(wrapper.getOutput());
                c.register(rawWriter);
                String[] escapedRow = new String[this.getColumnCount()];
                Enumeration e = this.mTable.keys();
                while (e.hasMoreElements()) {
                    String[] row = (String[])this.mTable.get(e.nextElement());
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        escapedRow[i] = this.getEscape().escape(row[i]);
                    }
                    rawWriter.getWriter().write(CSVUtil.composePSV(escapedRow));
                    rawWriter.getWriter().write(StringUtil.LINE_SEPARATOR);
                }
                wrapper.setValid(true);
            }
            finally {
                c.closeAll();
            }
            this.mDirty = false;
        }
    }
}

