/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.minidb;

import [Ljava.lang.String;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.minidb.PackageInfo;
import com.raplix.util.minidb.SearchCriteria;
import com.raplix.util.string.CSVUtil;
import com.raplix.util.string.Escape;
import com.raplix.util.string.JavaEscape;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ReadOnlyTable {
    protected Hashtable mTable = new Hashtable();
    private String mFile;
    private int mColumnCount;
    private int mKeyIndex;
    private boolean mLoaded = false;
    private Escape mEscape = JavaEscape.getGlobalInstance();

    public ReadOnlyTable(String file, int columnCount, int keyIndex) {
        this.mFile = file;
        this.mColumnCount = columnCount;
        this.mKeyIndex = keyIndex;
    }

    public ReadOnlyTable(String file, int columnCount) {
        this(file, columnCount, 0);
    }

    protected Escape getEscape() {
        return this.mEscape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws IOException {
        if (this.mLoaded) {
            return;
        }
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            if (this.mLoaded) {
                return;
            }
            FileReader rawReader = null;
            try {
                rawReader = new FileReader(this.getFile());
            }
            catch (FileNotFoundException ex) {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn(PackageInfo.createNoOpen(this.getFile()), ex, this);
                }
                this.mLoaded = true;
                return;
            }
            try {
                String line;
                LineNumberReader reader = new LineNumberReader(rawReader);
                while ((line = reader.readLine()) != null) {
                    String[] row = CSVUtil.splitPSV(line);
                    if (row.length != this.getColumnCount()) {
                        throw PackageInfo.createBadColumnCountFile(this.getFile(), reader.getLineNumber(), this.getColumnCount(), row.length);
                    }
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        row[i] = this.getEscape().unescape(row[i]);
                    }
                    String key = row[this.getKeyIndex()];
                    if (this.mTable.get(key) != null) {
                        throw PackageInfo.createDuplicateKeyFile(this.getFile(), reader.getLineNumber(), key);
                    }
                    this.mTable.put(key, row);
                }
                this.mLoaded = true;
            }
            finally {
                rawReader.close();
            }
        }
    }

    public String getFile() {
        return this.mFile;
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public int getKeyIndex() {
        return this.mKeyIndex;
    }

    public String[] query(String key) throws IOException {
        this.load();
        String[] row = (String[])this.mTable.get(key);
        if (row != null) {
            return row;
        }
        throw PackageInfo.createKeyNotExist(key);
    }

    public String[] search(SearchCriteria criteria) throws IOException {
        this.load();
        Vector<String> matches = new Vector<String>();
        Enumeration e = this.mTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] row = (String[])this.mTable.get(key);
            if (!criteria.matches(row)) continue;
            matches.addElement(key);
        }
        return (String[])CollectionUtil.mapClass(matches, String;.class);
    }

    public String[] getKeys() throws IOException {
        this.load();
        return (String[])CollectionUtil.mapClass(this.mTable.keySet(), String;.class);
    }
}

