/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.minidb;

import com.raplix.util.message.MessageManager;
import java.io.IOException;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.minidb";
    public static final String WARN_NO_OPEN = "util.minidb.WARN_NO_OPEN";
    public static final String EX_KEY_EXISTS = "util.minidb.EX_KEY_EXISTS";
    public static final String EX_KEY_NOT_EXIST = "util.minidb.EX_KEY_NOT_EXIST";
    public static final String EX_BAD_COLUMN_COUNT = "util.minidb.EX_BAD_COLUMN_COUNT";
    public static final String EX_BAD_COLUMN_COUNT_FILE = "util.minidb.EX_BAD_COLUMN_COUNT_FILE";
    public static final String EX_DUPLICATE_KEY_FILE = "util.minidb.EX_DUPLICATE_KEY_FILE";

    private PackageInfo() {
    }

    public static String createNoOpen(String name) {
        return MessageManager.messageAsString(WARN_NO_OPEN, new Object[]{name});
    }

    public static IOException createKeyExists(String key) {
        return new IOException(MessageManager.messageAsString(EX_KEY_EXISTS, new Object[]{key}));
    }

    public static IOException createKeyNotExist(String key) {
        return new IOException(MessageManager.messageAsString(EX_KEY_NOT_EXIST, new Object[]{key}));
    }

    public static IllegalArgumentException createBadColumnCount(int expected, int actual) {
        return new IllegalArgumentException(MessageManager.messageAsString(EX_BAD_COLUMN_COUNT, new Object[]{new Integer(expected), new Integer(actual)}));
    }

    public static IOException createBadColumnCountFile(String file, int line, int expected, int actual) {
        return new IOException(MessageManager.messageAsString(EX_BAD_COLUMN_COUNT_FILE, new Object[]{file, new Integer(line), new Integer(expected), new Integer(actual)}));
    }

    public static IOException createDuplicateKeyFile(String file, int line, String key) {
        return new IOException(MessageManager.messageAsString(EX_DUPLICATE_KEY_FILE, new Object[]{file, new Integer(line), key}));
    }
}

