/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.message;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import java.util.Date;

public class PortableMessage
implements RPCSerializable {
    private String mTokenKey;
    private String[] mArguments;
    private int[] mArgumentTypes;
    private static final int STRING = 0;
    private static final int DATE = 1;
    private static final int NUMBER = 2;

    protected PortableMessage(String inTokenKey, Object[] inArguments) {
        if (null == inTokenKey) {
            throw new NullPointerException("Token name cannot be null");
        }
        this.mTokenKey = inTokenKey;
        if (null != inArguments) {
            this.encodeArguments(inArguments);
        }
    }

    protected PortableMessage(String inTokenKey) {
        this(inTokenKey, null);
    }

    protected PortableMessage() {
    }

    protected Object[] decodeArguments() {
        if (null == this.mArguments || null == this.mArgumentTypes || this.mArguments.length != this.mArgumentTypes.length) {
            return null;
        }
        Object[] arguments = new Object[this.mArguments.length];
        block4: for (int index = 0; index < this.mArguments.length; ++index) {
            switch (this.mArgumentTypes[index]) {
                case 1: {
                    arguments[index] = new Date(Long.valueOf(this.mArguments[index]));
                    continue block4;
                }
                case 2: {
                    arguments[index] = Double.valueOf(this.mArguments[index]);
                    continue block4;
                }
                default: {
                    arguments[index] = this.mArguments[index];
                }
            }
        }
        return arguments;
    }

    protected void encodeArguments(Object[] inArguments) {
        if (null == inArguments) {
            this.mArguments = null;
            this.mArgumentTypes = null;
            return;
        }
        this.mArguments = new String[inArguments.length];
        this.mArgumentTypes = new int[inArguments.length];
        for (int index = 0; index < inArguments.length; ++index) {
            if (inArguments[index] instanceof Date) {
                this.mArgumentTypes[index] = 1;
                this.mArguments[index] = Long.toString(((Date)inArguments[index]).getTime());
                continue;
            }
            if (inArguments[index] instanceof Number) {
                this.mArgumentTypes[index] = 2;
                this.mArguments[index] = Double.toString(((Number)inArguments[index]).doubleValue());
                continue;
            }
            this.mArgumentTypes[index] = 0;
            Object arg = inArguments[index];
            this.mArguments[index] = arg == null ? null : arg.toString();
        }
    }

    public Object[] getArguments() {
        Object[] arguments = this.decodeArguments();
        return arguments;
    }

    public String getKey() {
        return this.mTokenKey;
    }
}

