/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.message;

import com.raplix.util.logger.Logger;
import com.raplix.util.message.PortableMessage;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManager {
    public static final String MESSAGE_NOT_FOUND_KEY = "messageNotFound";
    protected static final String MESSAGE_NOT_FOUND_MESSAGE = "The message could not be looked up.  Please make sure the message catalog files exist and are readable.";
    protected static final String CATALOG_NAME = "rolloutexpress_messages";
    private static Hashtable mBundles = new Hashtable();

    public static PortableMessage message(String inKeyName) {
        return new PortableMessage(inKeyName);
    }

    public static String messageAsString(String inKeyName) {
        return MessageManager.message(inKeyName, null, MessageManager.getDefaultLocale());
    }

    public static String messageAsString(String inKeyName, Locale inLocale) {
        return MessageManager.message(inKeyName, null, inLocale);
    }

    public static PortableMessage message(String inKeyName, Object[] inArguments) {
        return new PortableMessage(inKeyName, inArguments);
    }

    public static String messageAsString(String inKeyName, Object[] inArguments) {
        return MessageManager.message(inKeyName, inArguments, MessageManager.getDefaultLocale());
    }

    public static String messageAsString(String inKeyName, Object[] inArguments, Locale inLocale) {
        return MessageManager.message(inKeyName, inArguments, inLocale);
    }

    public static String messageAsString(PortableMessage inMessage, Locale inLocale) {
        return MessageManager.message(null == inMessage ? null : inMessage.getKey(), null == inMessage ? null : inMessage.getArguments(), inLocale);
    }

    public static String messageAsString(PortableMessage inMessage) {
        return MessageManager.messageAsString(inMessage, MessageManager.getDefaultLocale());
    }

    protected static String message(String inKeyName, Object[] inArguments, Locale inLocale) {
        if (null == inKeyName || 0 == inKeyName.length()) {
            return "";
        }
        String token = "";
        try {
            token = MessageManager.getToken(inKeyName, inLocale);
        }
        catch (MissingResourceException mre) {
            if (Logger.isInfoEnabled(MessageManager.class)) {
                Logger.info("Message \"" + inKeyName + "\" could not be found", mre, MessageManager.class);
            }
            try {
                return MessageManager.getToken(MESSAGE_NOT_FOUND_KEY, inLocale);
            }
            catch (MissingResourceException mre2) {
                if (Logger.isErrorEnabled(MessageManager.class)) {
                    Logger.error("The \"message not found\" message could not be found.  Please make sure the message catalog files exist and are readable.", mre2, MessageManager.class);
                }
                return MESSAGE_NOT_FOUND_MESSAGE;
            }
        }
        String output = token;
        if (null != inArguments) {
            MessageFormat message = new MessageFormat(token);
            message.setLocale(inLocale);
            output = message.format(inArguments);
        }
        return output;
    }

    private static String getToken(String inKeyName, Locale inLocale) throws MissingResourceException {
        return MessageManager.getResources(inLocale).getString(inKeyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getResources(Locale inLocale) throws MissingResourceException {
        ResourceBundle bundle = (ResourceBundle)mBundles.get(inLocale);
        if (bundle == null) {
            Hashtable hashtable = mBundles;
            synchronized (hashtable) {
                bundle = (ResourceBundle)mBundles.get(inLocale);
                if (bundle == null) {
                    if (Logger.isDebugEnabled(MessageManager.class)) {
                        Logger.debug("Bundle init:" + inLocale, MessageManager.class);
                    }
                    bundle = ResourceBundle.getBundle(CATALOG_NAME, inLocale);
                    mBundles.put(inLocale, bundle);
                }
            }
        }
        return bundle;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }
}

