/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.users;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.users.ExternalUsers;
import com.raplix.util.memix.users.PackageInfo;
import com.raplix.util.memix.users.UID;
import com.raplix.util.memix.users.UserTableEntry;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;

public class Users {
    private MessageDigest mDigest;
    private ExternalUsers mExternalUsers;
    private Hashtable mTable = new Hashtable();

    public Users(MessageDigest digest, ExternalUsers externalUsers) {
        this.mDigest = digest;
        this.mExternalUsers = externalUsers;
    }

    public UID create(ProcessContext context, String name, String password, FID home, GID defaultGroupID, Hashtable defaultEnv) {
        if (context != null && !context.isPrivileged()) {
            PackageInfo.throwNoPermission();
        }
        UID ID2 = UID.generateNewID();
        byte[] pwd = password == null ? null : this.mDigest.digest(password.getBytes());
        this.mTable.put(ID2, new UserTableEntry(name, pwd, home, defaultGroupID, defaultEnv));
        return ID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UID find(String name) {
        UID ID2;
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            Enumeration e = this.mTable.keys();
            while (e.hasMoreElements()) {
                UID ID3 = (UID)e.nextElement();
                if (!((UserTableEntry)this.mTable.get(ID3)).matchesName(name)) continue;
                return ID3;
            }
        }
        if (this.mExternalUsers != null && (ID2 = this.mExternalUsers.find(name)) != null) {
            return ID2;
        }
        PackageInfo.throwUnknownUser(name);
        return null;
    }

    public void remove(ProcessContext context, UID ID2) {
        this.getEntry(ID2);
        if (context != null && !context.isPrivileged()) {
            PackageInfo.throwNoPermission();
        }
        this.mTable.remove(ID2);
    }

    public boolean exists(UID ID2) {
        return this.mTable.get(ID2) != null;
    }

    public UserTableEntry getEntry(UID ID2) {
        UserTableEntry e;
        if (ID2 != null && (e = (UserTableEntry)this.mTable.get(ID2)) != null) {
            return e;
        }
        PackageInfo.throwUnknownUser(ID2);
        return null;
    }

    public void authenticate(UID ID2, String password) {
        UserTableEntry e = this.getEntry(ID2);
        if (password == null) {
            e.authenticate(null);
            return;
        }
        e.authenticate(this.mDigest.digest(password.getBytes()));
    }
}

