/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.users;

import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.users.PackageInfo;
import java.security.MessageDigest;
import java.util.Hashtable;

public class UserTableEntry {
    private String mName;
    private byte[] mPassword;
    private FID mHome;
    private GID mDefaultGroupID;
    private Hashtable mDefaultEnv;

    public UserTableEntry(String name, byte[] password, FID home, GID defaultGroupID, Hashtable defaultEnv) {
        this.mName = name;
        this.mPassword = password;
        this.mHome = home;
        this.mDefaultGroupID = defaultGroupID;
        this.mDefaultEnv = defaultEnv;
    }

    public String getName() {
        return this.mName;
    }

    public FID getHome() {
        return this.mHome;
    }

    public GID getDefaultGroupID() {
        return this.mDefaultGroupID;
    }

    public Hashtable getDefaultEnvironment() {
        return this.mDefaultEnv;
    }

    public boolean matchesName(String name) {
        return this.getName().equals(name);
    }

    public void authenticate(byte[] password) {
        if (!(this.mPassword == null || password != null && MessageDigest.isEqual(this.mPassword, password))) {
            PackageInfo.throwAuthenticationFailed(this.getName());
        }
    }
}

