/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.users;

import com.raplix.util.memix.MemixAccessControlException;
import com.raplix.util.memix.MemixIllegalArgumentException;
import com.raplix.util.memix.users.UID;
import com.raplix.util.message.MessageManager;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.memix.users";
    public static final String EX_NO_PERMISSION = "util.memix.users.EX_NO_PERMISSION";
    public static final String EX_UNKNOWN_USER = "util.memix.users.EX_UNKNOWN_USER";
    public static final String EX_AUTHENTICATION_FAILED = "util.memix.users.EX_AUTHENTICATION_FAILED";

    private PackageInfo() {
    }

    public static void throwNoPermission() {
        throw new MemixAccessControlException(MessageManager.messageAsString(EX_NO_PERMISSION));
    }

    public static void throwUnknownUser(UID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_USER, new Object[]{ID2}));
    }

    public static void throwUnknownUser(String name) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_USER, new Object[]{name}));
    }

    public static void throwAuthenticationFailed(String name) {
        throw new MemixAccessControlException(MessageManager.messageAsString(EX_AUTHENTICATION_FAILED, new Object[]{name}));
    }
}

