/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.processes;

import [Lcom.raplix.util.memix.processes.PID;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.PackageInfo;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.UID;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class Processes {
    private Hashtable mTable = new Hashtable();

    public PID create(UID realUserID, UID effectiveUserID, GID realGroupID, GID effectiveGroupID, String[] arguments, PrintWriter stdout, PrintWriter stderr, Mask mask, FID workingDirectory, Hashtable environment) {
        PID ID2 = PID.generateNewID();
        this.mTable.put(ID2, new ProcessTableEntry(realUserID, effectiveUserID, realGroupID, effectiveGroupID, arguments, stdout, stderr, mask, workingDirectory, environment));
        return ID2;
    }

    public PID fork(PID parentID) {
        ProcessTableEntry e = this.getEntry(parentID);
        PID ID2 = PID.generateNewID();
        this.mTable.put(ID2, new ProcessTableEntry(parentID, e));
        return ID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ProcessContext context, PID ID2) {
        ProcessTableEntry pe = this.getEntry(ID2);
        if (!(context == null || context.isPrivileged() || context.isUser(pe.getRealUserID()) || context.getProcessEntry().getRealUserID().equals(pe.getRealUserID()))) {
            PackageInfo.throwNoPermission();
        }
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            this.mTable.remove(ID2);
            if (context != null) {
                PID initID = context.getHost().getInitContext().getProcessID();
                Enumeration e = this.mTable.elements();
                while (e.hasMoreElements()) {
                    pe = (ProcessTableEntry)e.nextElement();
                    if (!ID2.equals(pe.getParentID())) continue;
                    pe.setParentID(null, initID);
                }
            }
        }
    }

    public boolean exists(PID ID2) {
        return this.mTable.get(ID2) != null;
    }

    public ProcessTableEntry getEntry(PID ID2) {
        ProcessTableEntry e = (ProcessTableEntry)this.mTable.get(ID2);
        if (e != null) {
            return e;
        }
        PackageInfo.throwUnknownProcess(ID2);
        return null;
    }

    public PID[] getAll() {
        return (PID[])CollectionUtil.mapClass(this.mTable.keySet(), PID;.class);
    }
}

