/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.processes;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.PackageInfo;
import com.raplix.util.memix.users.UID;
import java.io.PrintWriter;
import java.util.Hashtable;

public class ProcessTableEntry {
    private PID mParentID;
    private UID mRealUserID;
    private UID mEffectiveUserID;
    private GID mRealGroupID;
    private GID mEffectiveGroupID;
    private String[] mArguments;
    private PrintWriter mStdout;
    private PrintWriter mStderr;
    private Mask mMask;
    private FID mWorkingDirectory;
    private Hashtable mEnvironment = new Hashtable();

    public ProcessTableEntry(PID parentID, ProcessTableEntry parent) {
        this.mParentID = parentID;
        this.mRealUserID = parent.getRealUserID();
        this.mEffectiveUserID = parent.getEffectiveUserID();
        this.mRealGroupID = parent.getRealGroupID();
        this.mEffectiveGroupID = parent.getEffectiveGroupID();
        this.mArguments = parent.getArguments();
        this.mStdout = parent.getStdout();
        this.mStderr = parent.getStderr();
        this.mMask = parent.getMask();
        this.mWorkingDirectory = parent.getWorkingDirectory();
        this.mEnvironment.putAll(parent.mEnvironment);
    }

    public ProcessTableEntry(UID realUserID, UID effectiveUserID, GID realGroupID, GID effectiveGroupID, String[] arguments, PrintWriter stdout, PrintWriter stderr, Mask mask, FID workingDirectory, Hashtable environment) {
        this.mRealUserID = realUserID;
        this.mEffectiveUserID = effectiveUserID;
        this.mRealGroupID = realGroupID;
        this.mEffectiveGroupID = effectiveGroupID;
        this.mArguments = arguments;
        this.mStdout = stdout;
        this.mStderr = stderr;
        this.mMask = mask;
        this.mWorkingDirectory = workingDirectory;
        this.mEnvironment.putAll(environment);
    }

    public boolean isPrivilegedOrOwner(ProcessContext context) {
        return context == null || context.isPrivileged() || context.isUser(this.getRealUserID());
    }

    public void assertPrivilegedOrOwner(ProcessContext context) {
        if (!this.isPrivilegedOrOwner(context)) {
            PackageInfo.throwNoPermission();
        }
    }

    public void setParentID(ProcessContext context, PID ID2) {
        if (context != null && !context.isPrivileged()) {
            PackageInfo.throwNoPermission();
        }
        this.mParentID = ID2;
    }

    public PID getParentID() {
        return this.mParentID;
    }

    public void setRealUserID(ProcessContext context, UID ID2) {
        if (context != null && !context.isPrivileged()) {
            PackageInfo.throwNoPermission();
        }
        this.mRealUserID = ID2;
    }

    public UID getRealUserID() {
        return this.mRealUserID;
    }

    public void setEffectiveUserID(ProcessContext context, UID ID2) {
        if (context != null && !context.isPrivileged() && !this.getRealUserID().equals(ID2)) {
            PackageInfo.throwNoPermission();
        }
        this.mEffectiveUserID = ID2;
    }

    public UID getEffectiveUserID() {
        return this.mEffectiveUserID;
    }

    public void setRealGroupID(ProcessContext context, GID ID2) {
        if (context != null && !context.isPrivileged() && !context.isInGroup(ID2)) {
            PackageInfo.throwNoPermission();
        }
        this.mRealGroupID = ID2;
    }

    public GID getRealGroupID() {
        return this.mRealGroupID;
    }

    public void setEffectiveGroupID(ProcessContext context, GID ID2) {
        if (context != null && !context.isPrivileged() && !this.getRealGroupID().equals(ID2)) {
            PackageInfo.throwNoPermission();
        }
        this.mEffectiveGroupID = ID2;
    }

    public GID getEffectiveGroupID() {
        return this.mEffectiveGroupID;
    }

    public void setArguments(ProcessContext context, String[] arguments) {
        this.assertPrivilegedOrOwner(context);
        this.mArguments = arguments;
    }

    public String[] getArguments() {
        return this.mArguments;
    }

    public void setStdout(ProcessContext context, PrintWriter stdout) {
        this.assertPrivilegedOrOwner(context);
        this.mStdout = stdout;
    }

    public PrintWriter getStdout() {
        return this.mStdout;
    }

    public void setStderr(ProcessContext context, PrintWriter stderr) {
        this.assertPrivilegedOrOwner(context);
        this.mStderr = stderr;
    }

    public PrintWriter getStderr() {
        return this.mStderr;
    }

    public void setMask(ProcessContext context, Mask mask) {
        this.assertPrivilegedOrOwner(context);
        this.mMask = mask;
    }

    public Mask getMask() {
        return this.mMask;
    }

    public void setWorkingDirectory(ProcessContext context, FID workingDirectory) {
        this.assertPrivilegedOrOwner(context);
        this.mWorkingDirectory = workingDirectory;
    }

    public FID getWorkingDirectory() {
        return this.mWorkingDirectory;
    }

    public void setEnv(ProcessContext context, String name, Object value) {
        this.assertPrivilegedOrOwner(context);
        this.mEnvironment.put(name, value);
    }

    public void setEnv(ProcessContext context, Hashtable variables) {
        this.assertPrivilegedOrOwner(context);
        this.mEnvironment.putAll(variables);
    }

    public Object getEnv(String name) {
        return this.mEnvironment.get(name);
    }

    public Hashtable getEnv() {
        return (Hashtable)this.mEnvironment.clone();
    }
}

