/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.posix;

import com.raplix.util.logger.Logger;
import com.raplix.util.memix.Host;
import com.raplix.util.memix.filesystem.ExternalFileSystem;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.groups.GroupTableEntry;
import com.raplix.util.memix.posix.LsGFactory;
import com.raplix.util.memix.posix.LsUFactory;
import com.raplix.util.memix.posix.PosixFileSystem;
import com.raplix.util.memix.posix.PosixGroups;
import com.raplix.util.memix.posix.PosixUsers;
import com.raplix.util.memix.users.UID;
import com.raplix.util.platform.posix.Group;
import com.raplix.util.platform.posix.Passwd;
import com.raplix.util.platform.posix.Stat;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PosixHost
extends Host {
    private String mRoot;
    private int mRootLen;
    private String mRootBase;
    private String mSeparator;
    private Hashtable mUIDMap = new Hashtable();
    private Hashtable mGIDMap = new Hashtable();

    protected PosixHost() {
    }

    public PosixHost(String name, String root, String separator) {
        this.init(name, root, separator, new PosixFileSystem());
    }

    protected void init(String name, String root, String separator, PosixFileSystem fileSystem) {
        this.mSeparator = separator;
        this.mRoot = root;
        this.mRootLen = this.mRoot.length();
        this.mRootBase = this.mRoot.equals(this.mSeparator) ? "" : this.mRoot;
        this.init(name, new PosixUsers(this), new PosixGroups(this), (ExternalFileSystem)fileSystem);
        this.getCommands().register(this.getInitContext(), new LsUFactory(), LsUFactory.FILE_ID);
        this.getCommands().register(this.getInitContext(), new LsGFactory(), LsGFactory.FILE_ID);
    }

    public UID getUserID(Long pUID, Passwd pUser) {
        UID ID2;
        GID groupID = null;
        if (pUser == null) {
            groupID = this.getOtherGroupID();
            ID2 = this.getUsers().create(null, "P" + this.getUIDMap().size(), null, FID.ID_ROOT, groupID, new Hashtable());
        } else if ("root".equals(pUser.getName())) {
            ID2 = this.getPrivilegedUserID();
        } else {
            groupID = this.getGroupID(pUser.getGID());
            ID2 = this.getUsers().create(null, pUser.getName(), null, this.toID(pUser.getDir()), groupID, new Hashtable());
        }
        this.getUIDMap().put(pUID, ID2);
        if (groupID != null) {
            this.getGroups().getEntry(groupID).addUser(null, ID2);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Added user " + ID2 + " to group " + groupID, this);
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Created new user " + ID2 + " ('" + this.getUsers().getEntry(ID2).getName() + "'," + pUID + ")", this);
        }
        return ID2;
    }

    public GID getGroupID(Long pGID, Group pGroup) {
        GID ID2;
        if (pGroup == null) {
            ID2 = this.getGroups().create(null, "P" + this.getGIDMap().size(), null);
            this.getGIDMap().put(pGID, ID2);
        } else {
            ID2 = "root".equals(pGroup.getName()) ? this.getPrivilegedGroupID() : ("other".equals(pGroup.getName()) ? this.getOtherGroupID() : this.getGroups().create(null, pGroup.getName(), null));
            this.getGIDMap().put(pGID, ID2);
            GroupTableEntry e = this.getGroups().getEntry(ID2);
            String[] members = pGroup.getMem();
            for (int i = 0; i < members.length; ++i) {
                try {
                    Passwd pUser = new Passwd(members[i]);
                    UID userID = this.getUserID(pUser.getUID());
                    e.addUser(null, userID);
                    if (!Logger.isDebugEnabled(this)) continue;
                    Logger.debug("Added user " + userID + " to group " + ID2, this);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    if (!Logger.isDebugEnabled(this)) continue;
                    Logger.debug("Getting user '" + members[i] + "': " + ex.getMessage(), this);
                }
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Created new group " + ID2 + " ('" + this.getGroups().getEntry(ID2).getName() + "'," + pGID + ")", this);
        }
        return ID2;
    }

    public static long toMode(Mask mask) {
        long mode = 0L;
        if (mask.isUserReadable()) {
            mode |= Stat.RUSR;
        }
        if (mask.isUserWriteable()) {
            mode |= Stat.WUSR;
        }
        if (mask.isUserExecutable()) {
            mode |= Stat.XUSR;
        }
        if (mask.isGroupReadable()) {
            mode |= Stat.RGRP;
        }
        if (mask.isGroupWriteable()) {
            mode |= Stat.WGRP;
        }
        if (mask.isGroupExecutable()) {
            mode |= Stat.XGRP;
        }
        if (mask.isOthersReadable()) {
            mode |= Stat.ROTH;
        }
        if (mask.isOthersWriteable()) {
            mode |= Stat.WOTH;
        }
        if (mask.isOthersExecutable()) {
            mode |= Stat.XOTH;
        }
        if (mask.isSetUID()) {
            mode |= Stat.SUID;
        }
        if (mask.isSetGID()) {
            mode |= Stat.SGID;
        }
        if (mask.isSticky()) {
            mode |= Stat.SVTX;
        }
        return mode;
    }

    public static Mask toMask(long mode) {
        int mask = 0;
        if ((mode & Stat.RUSR) != 0L) {
            mask |= 0x100;
        }
        if ((mode & Stat.WUSR) != 0L) {
            mask |= 0x80;
        }
        if ((mode & Stat.XUSR) != 0L) {
            mask |= 0x40;
        }
        if ((mode & Stat.RGRP) != 0L) {
            mask |= 0x20;
        }
        if ((mode & Stat.WGRP) != 0L) {
            mask |= 0x10;
        }
        if ((mode & Stat.XGRP) != 0L) {
            mask |= 8;
        }
        if ((mode & Stat.ROTH) != 0L) {
            mask |= 4;
        }
        if ((mode & Stat.WOTH) != 0L) {
            mask |= 2;
        }
        if ((mode & Stat.XOTH) != 0L) {
            mask |= 1;
        }
        if ((mode & Stat.SUID) != 0L) {
            mask |= 0x800;
        }
        if ((mode & Stat.SGID) != 0L) {
            mask |= 0x400;
        }
        if ((mode & Stat.SVTX) != 0L) {
            mask |= 0x200;
        }
        return new Mask(mask);
    }

    public String getSeparator() {
        return this.mSeparator;
    }

    public String toName(FID ID2) {
        if (FID.ID_ROOT.equals(ID2)) {
            return this.mRoot;
        }
        FID[] IDs = ID2.split();
        StringBuffer buffer = new StringBuffer();
        if (!ID2.isRelative()) {
            buffer.append(this.mRootBase);
            buffer.append(this.mSeparator);
        }
        for (int i = 0; i < IDs.length; ++i) {
            if (i > 0) {
                buffer.append(this.mSeparator);
            }
            buffer.append(IDs[i].toString());
        }
        return buffer.toString();
    }

    public FID toID(String name) {
        FID ID2;
        StringTokenizer t;
        if (this.mRoot.startsWith(this.mSeparator) && name.startsWith(this.mRoot)) {
            t = new StringTokenizer(name.substring(this.mRootLen), this.mSeparator);
            ID2 = FID.ID_ROOT;
        } else {
            t = new StringTokenizer(name, this.mSeparator);
            if (name.startsWith(this.mSeparator)) {
                ID2 = FID.ID_ROOT;
            } else {
                if (!t.hasMoreTokens()) {
                    return FID.ID_EMPTY;
                }
                ID2 = new FID(t.nextToken());
            }
        }
        while (t.hasMoreTokens()) {
            ID2 = ID2.append(t.nextToken());
        }
        return ID2;
    }

    public Hashtable getGIDMap() {
        return this.mGIDMap;
    }

    public GID getGroupID(long pID) {
        Group pGroup;
        Long pGID;
        block3: {
            pGID = new Long(pID);
            GID ID2 = (GID)this.getGIDMap().get(pGID);
            if (ID2 != null) {
                return ID2;
            }
            pGroup = null;
            try {
                pGroup = new Group(pID);
            }
            catch (IllegalArgumentException ex) {
                if (!Logger.isDebugEnabled(this)) break block3;
                Logger.debug("Getting group '" + pID + "': " + ex.getMessage(), this);
            }
        }
        return this.getGroupID(pGID, pGroup);
    }

    public GID getGroupID(String pName) {
        Group pGroup;
        block3: {
            pGroup = null;
            try {
                pGroup = new Group(pName);
            }
            catch (IllegalArgumentException ex) {
                if (!Logger.isDebugEnabled(this)) break block3;
                Logger.debug("Getting group '" + pName + "': " + ex.getMessage(), this);
            }
        }
        if (pGroup == null) {
            return null;
        }
        return this.getGroupID(new Long(pGroup.getGID()), pGroup);
    }

    public Hashtable getUIDMap() {
        return this.mUIDMap;
    }

    public UID getUserID(long pID) {
        Passwd pUser;
        Long pUID;
        block3: {
            pUID = new Long(pID);
            UID ID2 = (UID)this.getUIDMap().get(pUID);
            if (ID2 != null) {
                return ID2;
            }
            pUser = null;
            try {
                pUser = new Passwd(pID);
            }
            catch (IllegalArgumentException ex) {
                if (!Logger.isDebugEnabled(this)) break block3;
                Logger.debug("Getting user '" + pID + "': " + ex.getMessage(), this);
            }
        }
        return this.getUserID(pUID, pUser);
    }

    public UID getUserID(String pName) {
        Passwd pUser;
        block3: {
            pUser = null;
            try {
                pUser = new Passwd(pName);
            }
            catch (IllegalArgumentException ex) {
                if (!Logger.isDebugEnabled(this)) break block3;
                Logger.debug("Getting user '" + pName + "': " + ex.getMessage(), this);
            }
        }
        if (pUser == null) {
            return null;
        }
        return this.getUserID(new Long(pUser.getUID()), pUser);
    }
}

