/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.posix;

import [Lcom.raplix.util.memix.filesystem.Node;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.memix.Host;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.Drive;
import com.raplix.util.memix.filesystem.ExternalFileSystem;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileNode;
import com.raplix.util.memix.filesystem.LinkNode;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.filesystem.MountNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.posix.PosixHost;
import com.raplix.util.memix.users.UID;
import com.raplix.util.platform.posix.Dir;
import com.raplix.util.platform.posix.Link;
import com.raplix.util.platform.posix.Stat;
import java.util.Vector;

public class PosixFileSystem
implements ExternalFileSystem {
    private PosixHost mHost;

    protected Drive getMountDrive(String name, FID ID2) {
        if (FID.ID_ROOT.equals(ID2)) {
            return this.getHost().getSystemDrive();
        }
        return null;
    }

    protected PosixHost getHost() {
        return this.mHost;
    }

    private Node mknod(String name, FID ID2) {
        Stat s = new Stat(name);
        GID groupID = this.getHost().getGroupID(s.getGID());
        UID userID = this.getHost().getUserID(s.getUID());
        this.getHost();
        Mask mask = PosixHost.toMask(s.getMode());
        long modified = s.getMTime() * 1000L;
        if (s.isDirectory()) {
            Drive drive = this.getMountDrive(name, ID2);
            if (drive != null) {
                return new MountNode(ID2, userID, groupID, mask, s.getSize(), modified, this, drive);
            }
            return new DirectoryNode(ID2, userID, groupID, mask, s.getSize(), modified);
        }
        if (s.isRegular()) {
            return new FileNode(ID2, userID, groupID, mask, s.getSize(), modified);
        }
        if (s.isLink()) {
            return new LinkNode(ID2, userID, groupID, mask, this.getHost().toID(Link.read(name)));
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Omitting '" + name + "' of native mode '" + s.getMode() + "'", this);
        }
        return null;
    }

    public void init(Host host) {
        this.mHost = (PosixHost)host;
    }

    public MountNode getRootNode() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("On-demand loading root", this);
        }
        return (MountNode)this.mknod(this.getHost().toName(FID.ID_ROOT), FID.ID_ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node[] getNodes(FID ID2) {
        Dir dir;
        String parentName = this.getHost().toName(ID2);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("On-demand loading '" + parentName + "'", this);
        }
        if (!parentName.endsWith(this.getHost().getSeparator())) {
            parentName = parentName + this.getHost().getSeparator();
        }
        try {
            dir = new Dir(parentName);
        }
        catch (IllegalArgumentException ex) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Getting dir '" + parentName + "': " + ex.getMessage(), this);
            }
            return new Node[0];
        }
        try {
            Dir.DirEnt e;
            Vector<Node> children = new Vector<Node>();
            while ((e = dir.read()).isValid()) {
                Node node;
                block11: {
                    if (e.getName().equals(".") || e.getName().equals("..")) continue;
                    String name = e.getName();
                    node = null;
                    try {
                        node = this.mknod(parentName + name, this.getHost().toID(name));
                    }
                    catch (IllegalArgumentException ex) {
                        if (!Logger.isDebugEnabled(this)) break block11;
                        Logger.debug("Making node '" + name + "': " + ex.getMessage(), this);
                    }
                }
                if (node == null) continue;
                children.addElement(node);
            }
            Node[] nodeArray = (Node[])CollectionUtil.mapClass(children, Node;.class);
            return nodeArray;
        }
        finally {
            dir.close();
        }
    }
}

