/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.posix;

import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.posix.PosixHost;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.UID;
import com.raplix.util.memix.users.UserTableEntry;
import com.raplix.util.memix.users.Users;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;

public class LsUCommand
extends Command {
    public LsUCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        ProcessTableEntry pe = this.getProcessEntry();
        PrintWriter out = pe.getStdout();
        PosixHost h = (PosixHost)this.getHost();
        Users u = h.getUsers();
        String[] args = pe.getArguments();
        if (args.length != 1) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        Hashtable map = h.getUIDMap();
        TreeSet pIDs = new TreeSet(map.keySet());
        Enumeration e = CollectionUtil.getEnumeration(pIDs);
        while (e.hasMoreElements()) {
            Long pID = (Long)e.nextElement();
            UID ID2 = (UID)map.get(pID);
            UserTableEntry entry = u.getEntry(ID2);
            out.print(entry.getName());
            out.print(':');
            out.print(pID);
            out.print(':');
            out.print(ID2);
            out.print(':');
            out.print(entry.getDefaultGroupID());
            out.print(':');
            out.println(entry.getHome());
        }
        this.kill();
    }
}

