/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.linux;

import com.raplix.util.PrintUtil;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.Drive;
import com.raplix.util.memix.linux.DfFactory;
import com.raplix.util.memix.linux.LinuxHost;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.string.StringUtil;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class DfCommand
extends Command {
    public DfCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        ProcessTableEntry pe = this.getProcessEntry();
        PrintWriter out = pe.getStdout();
        LinuxHost h = (LinuxHost)this.getHost();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, DfFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length != 0) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        boolean kBytes = args.get("-k") != null;
        PrintUtil.print(out, "Drive", 0, 15, false);
        out.print(' ');
        PrintUtil.print(out, "Device", 2, 10, false);
        out.print(' ');
        PrintUtil.print(out, "Total", 2, 10, false);
        out.print(' ');
        PrintUtil.print(out, "Used", 2, 10, false);
        out.print(' ');
        PrintUtil.print(out, "Available", 2, 10, false);
        out.print(' ');
        PrintUtil.print(out, "Use%", 2, 4, false);
        out.println(" Mounted on");
        Hashtable map = h.getDriveMap();
        Enumeration e = map.keys();
        while (e.hasMoreElements()) {
            Long pID = (Long)e.nextElement();
            LinuxHost.Mount m = (LinuxHost.Mount)map.get(pID);
            Drive d = m.getDrive();
            PrintUtil.print(out, d.getName(), 0, 15, false);
            out.print(' ');
            PrintUtil.print(out, pID.toString(), 2, 10, false);
            out.print(' ');
            if (d.getTotalBlocks() != 0L) {
                double scale = (double)d.getBlockSize() / 1024.0;
                long total = d.getTotalBlocks();
                if (kBytes) {
                    total = (long)((double)total * scale);
                }
                PrintUtil.print(out, Long.toString(total), 2, 10, false);
                out.print(' ');
                long used = d.getUsedBlocks();
                if (kBytes) {
                    used = (long)((double)used * scale);
                }
                PrintUtil.print(out, Long.toString(used), 2, 10, false);
                out.print(' ');
                long avail = d.getFreeBlocks();
                if (kBytes) {
                    avail = (long)((double)avail * scale);
                }
                PrintUtil.print(out, Long.toString(avail), 2, 10, false);
                out.print(' ');
                PrintUtil.print(out, Long.toString(Math.round((double)d.getUsedBlocks() * 100.0 / (double)d.getTotalBlocks())), 2, 3, false);
                out.print('%');
            } else {
                PrintUtil.print(out, null, 2, 10, false);
                out.print(' ');
                PrintUtil.print(out, null, 2, 10, false);
                out.print(' ');
                PrintUtil.print(out, null, 2, 10, false);
                out.print(' ');
                PrintUtil.print(out, null, 2, 4, false);
            }
            out.print(' ');
            out.println(m.getName());
        }
        this.kill();
    }
}

