/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.groups;

import com.raplix.util.memix.MemixAccessControlException;
import com.raplix.util.memix.MemixIllegalArgumentException;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.message.MessageManager;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.memix.groups";
    public static final String EX_NO_PERMISSION = "util.memix.groups.EX_NO_PERMISSION";
    public static final String EX_UNKNOWN_GROUP = "util.memix.groups.EX_UNKNOWN_GROUP";
    public static final String EX_AUTHENTICATION_FAILED = "util.memix.groups.EX_AUTHENTICATION_FAILED";

    private PackageInfo() {
    }

    public static void throwNoPermission() {
        throw new MemixAccessControlException(MessageManager.messageAsString(EX_NO_PERMISSION));
    }

    public static void throwUnknownGroup(GID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_GROUP, new Object[]{ID2}));
    }

    public static void throwUnknownGroup(String name) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_GROUP, new Object[]{name}));
    }

    public static void throwAuthenticationFailed(String name) {
        throw new MemixAccessControlException(MessageManager.messageAsString(EX_AUTHENTICATION_FAILED, new Object[]{name}));
    }
}

