/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.groups;

import [Lcom.raplix.util.memix.groups.GID;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.groups.ExternalGroups;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.groups.GroupTableEntry;
import com.raplix.util.memix.groups.PackageInfo;
import com.raplix.util.memix.users.UID;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Groups {
    private MessageDigest mDigest;
    private ExternalGroups mExternalGroups;
    private Hashtable mTable = new Hashtable();

    public Groups(MessageDigest digest, ExternalGroups externalGroups) {
        this.mDigest = digest;
        this.mExternalGroups = externalGroups;
    }

    public GID create(ProcessContext context, String name, String password) {
        if (context != null && !context.isPrivileged()) {
            PackageInfo.throwNoPermission();
        }
        GID ID2 = GID.generateNewID();
        byte[] pwd = password == null ? null : this.mDigest.digest(password.getBytes());
        this.mTable.put(ID2, new GroupTableEntry(name, pwd));
        return ID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GID find(String name) {
        GID ID2;
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            Enumeration e = this.mTable.keys();
            while (e.hasMoreElements()) {
                GID ID3 = (GID)e.nextElement();
                if (!((GroupTableEntry)this.mTable.get(ID3)).matchesName(name)) continue;
                return ID3;
            }
        }
        if (this.mExternalGroups != null && (ID2 = this.mExternalGroups.find(name)) != null) {
            return ID2;
        }
        PackageInfo.throwUnknownGroup(name);
        return null;
    }

    public void remove(ProcessContext context, GID ID2) {
        this.getEntry(ID2);
        if (context != null && !context.isPrivileged()) {
            PackageInfo.throwNoPermission();
        }
        this.mTable.remove(ID2);
    }

    public boolean exists(GID ID2) {
        return this.mTable.get(ID2) != null;
    }

    public GroupTableEntry getEntry(GID ID2) {
        GroupTableEntry e;
        if (ID2 != null && (e = (GroupTableEntry)this.mTable.get(ID2)) != null) {
            return e;
        }
        PackageInfo.throwUnknownGroup(ID2);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GID[] findWithMember(UID ID2) {
        Hashtable hashtable = this.mTable;
        synchronized (hashtable) {
            Vector<GID> result = new Vector<GID>();
            Enumeration e = this.mTable.keys();
            while (e.hasMoreElements()) {
                GID groupID = (GID)e.nextElement();
                if (!((GroupTableEntry)this.mTable.get(groupID)).containsUser(ID2)) continue;
                result.addElement(groupID);
            }
            return (GID[])CollectionUtil.mapClass(result, GID;.class);
        }
    }

    public void authenticate(GID groupID, UID userID, String password) {
        GroupTableEntry e = this.getEntry(groupID);
        if (password == null) {
            e.authenticate(userID, null);
            return;
        }
        e.authenticate(userID, this.mDigest.digest(password.getBytes()));
    }
}

