/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.groups;

import [Lcom.raplix.util.memix.users.UID;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.groups.PackageInfo;
import com.raplix.util.memix.users.UID;
import java.security.MessageDigest;
import java.util.HashSet;

public class GroupTableEntry {
    private String mName;
    private byte[] mPassword;
    private HashSet mUIDs = new HashSet();

    public GroupTableEntry(String name, byte[] password) {
        this.mName = name;
        this.mPassword = password;
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(ProcessContext context, UID ID2) {
        if (context != null && !context.isPrivileged()) {
            PackageInfo.throwNoPermission();
        }
        HashSet hashSet = this.mUIDs;
        synchronized (hashSet) {
            this.mUIDs.add(ID2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(ProcessContext context, UID ID2) {
        if (context != null && !context.isPrivileged()) {
            PackageInfo.throwNoPermission();
        }
        HashSet hashSet = this.mUIDs;
        synchronized (hashSet) {
            this.mUIDs.remove(ID2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsUser(UID ID2) {
        HashSet hashSet = this.mUIDs;
        synchronized (hashSet) {
            return this.mUIDs.contains(ID2);
        }
    }

    public UID[] getMemberIDs() {
        return (UID[])CollectionUtil.mapClass(this.mUIDs, UID;.class);
    }

    public boolean matchesName(String name) {
        return this.getName().equals(name);
    }

    public void authenticate(UID ID2, byte[] password) {
        if (!this.containsUser(ID2) || this.mPassword != null && (password == null || !MessageDigest.isEqual(this.mPassword, password))) {
            PackageInfo.throwAuthenticationFailed(this.getName());
        }
    }
}

